/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.io.IOException;
import java.util.HashSet;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;

public class DeleteNodeAction
extends NodeAction {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return true;
    }

    protected void performAction(Node[] nodes) {
        HashSet<Node> parentNodesToRefresh = new HashSet<Node>();
        boolean delete = false;
        boolean ask = false;
        if (nodes.length > 1) {
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.DeleteNodeAction.question2", nodes.length), 0)) == NotifyDescriptor.YES_OPTION) {
                delete = true;
            }
            ask = true;
        }
        for (Node node : nodes) {
            if (!(node instanceof EditorProvider)) continue;
            if (!ask && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.DeleteNodeAction.question1", "\"" + node.getName() + "\""), 0)) == NotifyDescriptor.YES_OPTION) {
                delete = true;
            }
            if (!delete) continue;
            try {
                node.destroy();
                parentNodesToRefresh.add(node.getParentNode());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        for (Node node : parentNodesToRefresh) {
            ((Refreshable)node).refresh();
        }
    }

    protected boolean enable(Node[] arg0) {
        return true;
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

