/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ActionMap;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.RootNode;

public final class MainTreeTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static MainTreeTopComponent instance;
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView view = new BeanTreeView();
    Node nodeToExpand;

    private MainTreeTopComponent() {
        this.setName(Messages.getString("CTL_MainTreeTopComponent"));
        this.setToolTipText(Messages.getString("HINT_MainTreeTopComponent"));
        Image loadImage = Utilities.loadImage((String)"org/openthinclient/console/rss16.gif", (boolean)true);
        this.setIcon(loadImage);
        this.setLayout(new BorderLayout());
        this.add((Component)this.view, "Center");
        this.view.setDefaultActionAllowed(true);
        this.view.setRootVisible(false);
        try {
            this.manager.setRootContext((Node)new RootNode());
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        ActionMap map = this.getActionMap();
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        map.put("copy", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("paste", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("cut", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("exploredContext")) {
                    MainTreeTopComponent.this.view.expandNode((Node)evt.getNewValue());
                }
            }
        });
        this.manager.setExploredContext(this.manager.getRootContext().getChildren().getNodes()[0]);
    }

    public static void expandThisNode(Node node) {
        MainTreeTopComponent.getDefault().view.expandNode(node);
    }

    public static synchronized MainTreeTopComponent getDefault() {
        if (instance == null) {
            instance = new MainTreeTopComponent();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return "MainTreeTopComponent";
    }

    protected Object writeReplace() {
        return new ResolvableHelper();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public boolean canClose() {
        return false;
    }

    private static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ResolvableHelper() {
        }

        public Object readResolve() {
            return MainTreeTopComponent.getDefault();
        }
    }
}

