/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.levigo.util.swing.IconManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.wizards.newdirobject.NewDirObjectTreeWizardIterator;
import org.openthinclient.ldap.DirectoryException;

public class NewAction
extends NodeAction {
    public NewAction() {
        this.setIcon(IconManager.getInstance(((Object)((Object)this)).getClass(), (String)"icons").getIcon("New"));
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Class childObjectClass = (Class)node.getLookup().lookup(Class.class);
            try {
                DirectoryObject object = (DirectoryObject)childObjectClass.newInstance();
                object.setName("New " + childObjectClass.getName());
                Realm realm = (Realm)node.getLookup().lookup(Realm.class);
                WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)new NewDirObjectTreeWizardIterator());
                wd.setTitleFormat(new MessageFormat("{0} ({1})"));
                wd.setTitle(Messages.getString("action.New" + childObjectClass.getSimpleName()));
                wd.putProperty("type", (Object)childObjectClass);
                wd.putProperty("realm", node.getLookup().lookup(Realm.class));
                Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
                dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
                dialog.setPreferredSize(new Dimension(830, 600));
                dialog.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation((screenSize.width - dialog.getWidth()) / 2, (screenSize.height - dialog.getHeight()) / 2);
                dialog.setVisible(true);
                dialog.toFront();
                if (wd.getValue() != WizardDescriptor.FINISH_OPTION) continue;
                DirectoryObject dirObject = (DirectoryObject)wd.getProperty("dirObject");
                try {
                    realm.getDirectory().save((Object)dirObject);
                    if (node == null || !(node instanceof Refreshable)) continue;
                    ((Refreshable)node).refresh();
                }
                catch (DirectoryException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Class currentClass = (Class)node.getLookup().lookup(Class.class);
            if (LDAPDirectory.isMutable((Class)currentClass)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.getString("New");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

