/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.Preferences;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.Messages;
import org.openthinclient.console.util.UsernamePasswordCallbackHandler;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class RealmManager {
    private static final Preferences prefs = ConsoleFrame.PREFERENCES_ROOT.node("realms");
    private static EventListenerList listeners = new EventListenerList();

    public static String[] getRegisteredRealmNames() throws BackingStoreException {
        return prefs.childrenNames();
    }

    public static Realm loadRealm(String realmName) throws BackingStoreException, IOException, ClassNotFoundException, DirectoryException {
        return new Realm(RealmManager.fromPreferences(prefs.node(realmName)));
    }

    public static void registerRealm(Realm realm) {
        CallbackHandler callbackHandler = realm.getConnectionDescriptor().getCallbackHandler();
        if (callbackHandler instanceof UsernamePasswordCallbackHandler) {
            try {
                ((UsernamePasswordCallbackHandler)((Object)callbackHandler)).setProtectionDomain(realm.getConnectionDescriptor().getLDAPUrl());
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Could not update protection domain.");
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            ErrorManager.getDefault().notify((Throwable)new IOException("CallbackHandler was not of the expected type, but " + callbackHandler.getClass()));
        }
        try {
            String baseName = realm.getConnectionDescriptor().getHostname() + realm.getConnectionDescriptor().getBaseDN();
            if (prefs.nodeExists(baseName)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Messages.getString("error.RealmAlreadyExists"), 2));
                return;
            }
            Preferences realmPrefs = prefs.node(baseName);
            RealmManager.toPreferences(realmPrefs, realm.getConnectionDescriptor());
            prefs.flush();
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    public static void deregisterRealm(String realmName) throws BackingStoreException {
        prefs.node(realmName).removeNode();
        prefs.flush();
    }

    public static void addChangeListener(ChangeListener changeListener) {
        listeners.add(ChangeListener.class, changeListener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        listeners.remove(ChangeListener.class, listener);
    }

    private static LDAPConnectionDescriptor fromPreferences(Preferences p) throws BackingStoreException, IOException, ClassNotFoundException {
        LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor();
        lcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.valueOf((String)p.get("authentication method", LDAPConnectionDescriptor.AuthenticationMethod.NONE.name())));
        lcd.setBaseDN(p.get("base DN", ""));
        lcd.setConnectionMethod(LDAPConnectionDescriptor.ConnectionMethod.valueOf((String)p.get("connection method", LDAPConnectionDescriptor.ConnectionMethod.PLAIN.name())));
        lcd.setHostname(p.get("hostname", "localhost"));
        lcd.setPortNumber((short)p.getInt("port", 10389));
        lcd.setProviderType(LDAPConnectionDescriptor.ProviderType.valueOf((String)p.get("provider type", LDAPConnectionDescriptor.ProviderType.SUN.name())));
        if (p.nodeExists("env")) {
            Preferences env = p.node("env");
            for (String name : env.keys()) {
                String v = p.get(name, null);
                Object value = null;
                if (v != null && v.length() != 0) {
                    switch (v.charAt(0)) {
                        case 'I': {
                            value = Integer.parseInt(v.substring(1));
                            break;
                        }
                        case 'S': {
                            value = v.substring(1);
                            break;
                        }
                        case 'O': {
                            byte[] b = p.getByteArray(name, null);
                            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b, 1, b.length));
                            value = ois.readObject();
                            ois.close();
                        }
                    }
                }
                lcd.getExtraEnv().put(name, value);
            }
        }
        lcd.setCallbackHandler((CallbackHandler)((Object)new UsernamePasswordCallbackHandler(lcd.getLDAPUrl())));
        return lcd;
    }

    private static void toPreferences(Preferences p, LDAPConnectionDescriptor lcd) throws IOException {
        p.put("authentication method", lcd.getAuthenticationMethod().name());
        p.put("base DN", lcd.getBaseDN());
        p.put("connection method", lcd.getConnectionMethod().name());
        p.put("hostname", lcd.getHostname());
        p.putInt("port", lcd.getPortNumber());
        p.put("provider type", lcd.getProviderType().name());
        Preferences env = p.node("env");
        for (Map.Entry e : lcd.getExtraEnv().entrySet()) {
            if (e.getValue() instanceof String) {
                env.put((String)e.getKey(), (String)e.getValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                env.putInt((String)e.getKey(), (Integer)e.getValue());
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(e.getValue());
            oos.flush();
            env.putByteArray((String)e.getKey(), baos.toByteArray());
        }
    }

    static {
        prefs.addNodeChangeListener(new NodeChangeListener(){

            @Override
            public void childRemoved(NodeChangeEvent nodechangeevent) {
                this.notify(nodechangeevent);
            }

            @Override
            public void childAdded(NodeChangeEvent nodechangeevent) {
                this.notify(nodechangeevent);
            }

            private void notify(NodeChangeEvent nodechangeevent) {
                if (listeners.getListenerCount() > 0) {
                    ChangeEvent e = new ChangeEvent(nodechangeevent);
                    for (ChangeListener l : (ChangeListener[])listeners.getListeners(ChangeListener.class)) {
                        l.stateChanged(e);
                    }
                }
            }
        });
    }
}

