/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;

class UIDefaults {
    private static final Logger LOGGER = Logger.getLogger(UIDefaults.class);

    private UIDefaults() {
    }

    public static void install(Component c) {
        UIDefaults.configureUI();
        SwingUtilities.updateComponentTreeUI(c);
    }

    private static void configureUI() {
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setUseNarrowButtons((boolean)false);
        Options.setTabIconsEnabled((boolean)true);
        PlasticXPLookAndFeel selectedLaf = new PlasticXPLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)PlasticLookAndFeel.createMyDefaultTheme());
            PlasticLookAndFeel.setTabStyle((String)"default");
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)false);
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel((LookAndFeel)selectedLaf);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Can't change L&F: ", e);
        }
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("lookAndFeel")) {
                    UIDefaults.overrideLAFDefaults();
                }
            }
        });
        UIDefaults.overrideLAFDefaults();
    }

    private static void overrideLAFDefaults() {
        UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
        UIManager.put("SplitPaneDivider.border", BorderFactory.createEmptyBorder());
    }
}

