/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.levigo.util.swing.SwingWorker;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.directory.server.tools.ToolCommandListener;
import org.apache.directory.server.tools.commands.exportcmd.ExportCommandExecutor;
import org.apache.directory.server.tools.commands.importcmd.ImportCommandExecutor;
import org.apache.directory.server.tools.util.ListenerParameter;
import org.apache.directory.server.tools.util.Parameter;
import org.apache.log4j.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.LdifActionProgressBar;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.RefreshAction;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.nodes.views.DirectoryEntryDetailView;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.TypeMapping;
import org.openthinclient.ldap.Util;

public class DirectoryEntryNode
extends MyAbstractNode
implements DetailViewProvider,
EditorProvider,
Refreshable {
    private static final Logger logger = Logger.getLogger(TypeMapping.class);
    private static final String BASEDN_REPLACE = "#%BASEDN%#";
    private final String rdn;
    private final String dn;
    private static boolean mutable;

    public static void importHTTPAction(LDAPConnectionDescriptor lcd, Set<File> importFiles) {
        LdifActionProgressBar bar = new LdifActionProgressBar();
        ImportWorker imp = new ImportWorker(lcd, importFiles, bar);
        imp.start();
        bar.loadDialog();
    }

    public static void importAction(LDAPConnectionDescriptor lcd, File importFile, LdifActionProgressBar bar) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("import following temporary file: " + importFile));
            }
            NameCallback nc = new NameCallback("Bind DN");
            PasswordCallback pc = new PasswordCallback("Password", false);
            lcd.getCallbackHandler().handle(new Callback[]{nc, pc});
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            ImportCommandExecutor importCommandExecutor = new ImportCommandExecutor();
            params.add(new Parameter("host", (Object)lcd.getHostname()));
            params.add(new Parameter("port", (Object)new Integer(lcd.getPortNumber())));
            switch (lcd.getAuthenticationMethod()) {
                case SIMPLE: {
                    params.add(new Parameter("auth", (Object)"simple"));
                    params.add(new Parameter("user", (Object)nc.getName()));
                    params.add(new Parameter("password", (Object)new String(pc.getPassword())));
                }
            }
            params.add(new Parameter("file", (Object)importFile));
            params.add(new Parameter("ignore-errors", (Object)new Boolean(true)));
            params.add(new Parameter("debug", (Object)new Boolean(false)));
            params.add(new Parameter("verbose", (Object)new Boolean(false)));
            params.add(new Parameter("quiet", (Object)new Boolean(false)));
            importCommandExecutor.execute(params.toArray(new Parameter[params.size()]), new ListenerParameter[0]);
            bar.finished(Messages.getString("LdifImportPanel.name"), Messages.getString("LdifImportPanel.text"));
        }
        catch (Throwable t) {
            bar.finished();
            logger.error((Object)"Could not import", t);
            ErrorManager.getDefault().annotate(t, "Could not import");
            ErrorManager.getDefault().notify(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importTempFile(File importFile, LDAPConnectionDescriptor lcd, LdifActionProgressBar bar) throws Exception {
        String strLine;
        FileInputStream fstream = new FileInputStream(importFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer content = new StringBuffer();
        String baseDn = lcd.getBaseDN();
        LdapContext ctx = lcd.createDirectoryFacade().createDirContext();
        Name targetName = ctx.getNameParser("").parse("");
        if (DirectoryEntryNode.isRootImportLdifFile(importFile)) {
            Util.deleteRecursively((DirContext)ctx, (Name)targetName, (String)"^cn=administrator[s]?$");
        }
        Pattern toReplace = Pattern.compile(".*#%BASEDN%#$");
        while ((strLine = br.readLine()) != null) {
            Matcher m = toReplace.matcher(strLine);
            if (m.matches()) {
                int pos = strLine.lastIndexOf(BASEDN_REPLACE);
                content.append(strLine.substring(0, pos) + baseDn).append(System.getProperty("line.separator"));
                continue;
            }
            content.append(strLine).append(System.getProperty("line.separator"));
        }
        in.close();
        File tempFile = File.createTempFile("openthinclient-import-", ".ldif");
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(tempFile.getAbsolutePath()));
            os.write(content.toString().getBytes());
        }
        finally {
            if (null != os) {
                os.flush();
                os.close();
            }
        }
        DirectoryEntryNode.importAction(lcd, tempFile, bar);
        tempFile.delete();
    }

    private static boolean isRootImportLdifFile(File importFile) throws IOException {
        FileInputStream fstream = new FileInputStream(importFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        br.readLine();
        return br.readLine().matches("^dn:[ ]+#%BASEDN%#$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createExportFile(File tempFile, String path, String dn, LdifActionProgressBar bar) throws Exception {
        String strLine;
        FileInputStream fstream = new FileInputStream(tempFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer content = new StringBuffer().append("version: 1").append(System.getProperty("line.separator"));
        Pattern toReplace = Pattern.compile("((^dn:)|(^uniquemember:)|(^l:)) .*" + dn + "$", 2);
        while ((strLine = br.readLine()) != null) {
            Matcher m = toReplace.matcher(strLine);
            if (m.matches()) {
                int pos = strLine.lastIndexOf(dn);
                content.append(strLine.substring(0, pos) + BASEDN_REPLACE).append(System.getProperty("line.separator"));
                continue;
            }
            content.append(strLine).append(System.getProperty("line.separator"));
        }
        in.close();
        tempFile.delete();
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(path));
            os.write(content.toString().getBytes());
        }
        finally {
            if (null != os) {
                os.flush();
                os.close();
            }
        }
    }

    public DirectoryEntryNode(Node node, String dn) {
        super((Children)new ChildEntries(dn), node.getLookup());
        this.dn = dn;
        int i = dn.indexOf(44);
        this.rdn = i > 0 ? dn.substring(0, i) : dn;
    }

    public DirectoryEntryNode(Children c, Node node, LDAPConnectionDescriptor lcd, String dn) {
        super(c, (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{lcd}), node.getLookup()}));
        this.dn = this.rdn = dn;
    }

    public DirectoryEntryNode(Node node, LDAPConnectionDescriptor lcd, String dn) {
        this((Children)new ChildEntries(dn), node, lcd, dn);
    }

    public LDAPConnectionDescriptor getConnectionDescriptor() {
        LDAPConnectionDescriptor lcd = (LDAPConnectionDescriptor)this.getLookup().lookup(LDAPConnectionDescriptor.class);
        String secViewName = Messages.getString("SecondaryDirectoryViewNode.name");
        String levelOne = "";
        String levelTwo = "";
        String levelThree = "";
        boolean isSec = false;
        try {
            levelOne = this.getDisplayName();
            levelTwo = this.getParentNode().getName();
            levelThree = this.getParentNode().getParentNode().getName();
            isSec = levelOne.equals(secViewName) || levelTwo.equals(secViewName) || levelThree.equals(secViewName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        mutable = true;
        return lcd;
    }

    @Override
    public String getName() {
        return this.dn;
    }

    public String getDisplayName() {
        return this.rdn;
    }

    public Action[] getActions(boolean context) {
        if (this.isWritable()) {
            if (this.getParentNode() instanceof RealmNode) {
                return new Action[]{SystemAction.get(ExportLDIFAction.class), SystemAction.get(ImportLDIFAction.class), null, SystemAction.get(RefreshAction.class)};
            }
            return new Action[]{SystemAction.get(ExportLDIFAction.class), null, SystemAction.get(RefreshAction.class)};
        }
        return new Action[]{SystemAction.get(ExportLDIFAction.class), null, SystemAction.get(RefreshAction.class)};
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        try {
            try {
                LDAPConnectionDescriptor lcd = this.getConnectionDescriptor();
                Realm realm = new Realm();
                realm.setConnectionDescriptor(lcd);
                LDAPDirectory dir = realm.getDirectory();
                DirectoryFacade df = lcd.createDirectoryFacade();
                try (LdapContext ctx = df.createDirContext();){
                    Name targetName = df.makeRelativeName(this.dn);
                    Util.deleteRecursively((DirContext)ctx, (Name)targetName);
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
    }

    public boolean canRename() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String s) {
        boolean isRightDN;
        String sEdit = LDAPDirectory.idToUpperCase((String)s);
        String rest = LDAPDirectory.idToUpperCase((String)this.dn).replace(LDAPDirectory.idToUpperCase((String)this.rdn) + ",", "");
        boolean bl = isRightDN = (sEdit.startsWith("CN=") || sEdit.startsWith("L=")) && sEdit.endsWith(rest);
        if (null == s || s.length() == 0 || !isRightDN) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Messages.getString("DirectoryEntryNode.nameInvalid", s), Messages.getString("DirectoryEntryNode.cantChangeName"), -1, 0, null, null));
            return;
        }
        try {
            LDAPConnectionDescriptor lcd = this.getConnectionDescriptor();
            DirectoryFacade df = lcd.createDirectoryFacade();
            try (LdapContext ctx = df.createDirContext();){
                Name oldName = df.makeRelativeName(this.dn);
                Name newName = df.makeRelativeName(s);
                ctx.rename(oldName, newName);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DetailView getDetailView() {
        return new DirectoryEntryDetailView();
    }

    @Override
    public DetailView getEditor() {
        return new DirectoryEntryDetailView();
    }

    @Override
    public void refresh() {
        ((AbstractAsyncArrayChildren)this.getChildren()).refreshChildren();
    }

    public String getDn() {
        return this.dn;
    }

    public String getRdn() {
        return this.rdn;
    }

    static class ChildEntries
    extends AbstractAsyncArrayChildren {
        private final String dn;

        public ChildEntries(String dn) {
            this.dn = dn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Collection asyncInitChildren() {
            try {
                LDAPConnectionDescriptor lcd = ((DirectoryEntryNode)this.getNode()).getConnectionDescriptor();
                if (lcd == null) {
                    return Collections.EMPTY_LIST;
                }
                LdapContext ctx = lcd.createDirectoryFacade().createDirContext();
                try {
                    List<String> list;
                    NamingEnumeration<NameClassPair> bindings = ctx.list(ctx.getNameParser("").parse(this.dn));
                    ArrayList<String> names = new ArrayList<String>();
                    if (null != bindings) {
                        while (bindings.hasMoreElements()) {
                            NameClassPair b = bindings.next();
                            String name = b.isRelative() ? b.getName() + (this.dn.length() > 0 ? "," + this.dn : "") : b.getName();
                            names.add(name);
                        }
                    }
                    if (mutable) {
                        list = names;
                        return list;
                    }
                    list = Collections.EMPTY_LIST;
                    return list;
                }
                finally {
                    if (null != ctx) {
                        ctx.close();
                    }
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.add(new Node[]{new ErrorNode(Messages.getString("DirectoryEntryNode.cantDisplay"), e)});
                return Collections.EMPTY_LIST;
            }
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node[]) {
                return (Node[])key;
            }
            return new Node[]{new DirectoryEntryNode(this.getNode(), (String)key)};
        }
    }

    static final class ImportWorker
    extends SwingWorker {
        private final LDAPConnectionDescriptor lcd;
        private final Set<File> importFiles;
        private final LdifActionProgressBar bar;
        private boolean interrupt = false;

        public ImportWorker(LDAPConnectionDescriptor lcd, Set<File> importFiles, LdifActionProgressBar bar) {
            this.lcd = lcd;
            this.importFiles = importFiles;
            this.bar = bar;
        }

        public Object construct() {
            try {
                for (File importFile : this.importFiles) {
                    if (importFile == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("import following temporary file: " + importFile));
                    }
                    NameCallback nc = new NameCallback("Bind DN");
                    PasswordCallback pc = new PasswordCallback("Password", false);
                    this.lcd.getCallbackHandler().handle(new Callback[]{nc, pc});
                    ArrayList<Parameter> params = new ArrayList<Parameter>();
                    ImportCommandExecutor importCommandExecutor = new ImportCommandExecutor();
                    params.add(new Parameter("host", (Object)this.lcd.getHostname()));
                    params.add(new Parameter("port", (Object)new Integer(this.lcd.getPortNumber())));
                    switch (this.lcd.getAuthenticationMethod()) {
                        case SIMPLE: {
                            params.add(new Parameter("auth", (Object)"simple"));
                            params.add(new Parameter("user", (Object)nc.getName()));
                            params.add(new Parameter("password", (Object)new String(pc.getPassword())));
                        }
                    }
                    params.add(new Parameter("file", (Object)importFile));
                    params.add(new Parameter("ignore-errors", (Object)new Boolean(true)));
                    params.add(new Parameter("debug", (Object)new Boolean(false)));
                    params.add(new Parameter("verbose", (Object)new Boolean(false)));
                    params.add(new Parameter("quiet", (Object)new Boolean(false)));
                    importCommandExecutor.execute(params.toArray(new Parameter[params.size()]), new ListenerParameter[0]);
                    importFile.delete();
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Could not import", t);
                ErrorManager.getDefault().annotate(t, "Could not import");
                ErrorManager.getDefault().notify(t);
                return false;
            }
            return true;
        }

        public void finished() {
            this.interrupt = true;
            this.bar.finished(Messages.getString("LdifImportPanel.name"), Messages.getString("LdifImportPanel.text"));
        }

        public boolean getInterrupt() {
            return this.interrupt;
        }
    }

    private static class ImportLDIFAction
    extends NodeAction {
        private static final long serialVersionUID = 1L;
        LDAPConnectionDescriptor lcd;

        private ImportLDIFAction() {
        }

        protected boolean asynchronous() {
            return true;
        }

        public String getName() {
            return "Import LDIF";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected void performAction(Node[] activatedNodes) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Import object tree from LDIF");
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "LDIF files";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".ldif") || f.getName().endsWith(".txt");
                }
            });
            this.lcd = (LDAPConnectionDescriptor)activatedNodes[0].getLookup().lookup(LDAPConnectionDescriptor.class);
            if (chooser.showDialog((Component)((Object)MainTreeTopComponent.getDefault()), "Import") == 0) {
                LdifActionProgressBar bar = new LdifActionProgressBar();
                bar.startProgress();
                File importFile = chooser.getSelectedFile();
                try {
                    DirectoryEntryNode.importTempFile(importFile, this.lcd, bar);
                    Node parentNode = activatedNodes[0].getParentNode();
                    if (parentNode instanceof RealmNode && parentNode instanceof Refreshable) {
                        ((Refreshable)parentNode).refresh();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Could not import", (Throwable)e);
                    bar.finished(Messages.getString("LdifImportPanel.name"), e.toString());
                }
            }
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1 && activatedNodes[0] instanceof DirectoryEntryNode;
        }
    }

    private static class ExportLDIFAction
    extends NodeAction {
        private static final long serialVersionUID = 1L;

        private ExportLDIFAction() {
        }

        protected boolean asynchronous() {
            return true;
        }

        public String getName() {
            return "Export LDIF";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performAction(Node[] activatedNodes) {
            boolean isSec;
            LdifActionProgressBar bar = new LdifActionProgressBar();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Export object tree as LDIF");
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "LDIF files";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".ldif") || f.getName().endsWith(".txt");
                }
            });
            LDAPConnectionDescriptor lcd = (LDAPConnectionDescriptor)activatedNodes[0].getLookup().lookup(LDAPConnectionDescriptor.class);
            String secViewName = Messages.getString("SecondaryDirectoryViewNode.name");
            boolean bl = isSec = activatedNodes[0].getDisplayName().equals(secViewName) || activatedNodes[0].getParentNode().getName().equals(secViewName) || activatedNodes[0].getParentNode().getParentNode().getName().equals(secViewName);
            if (chooser.showDialog((Component)((Object)MainTreeTopComponent.getDefault()), "Export") == 0) {
                bar.startProgress();
                String dn = ((DirectoryEntryNode)activatedNodes[0]).getDn();
                try {
                    NameCallback nc = new NameCallback("Bind DN");
                    PasswordCallback pc = new PasswordCallback("Password", false);
                    lcd.getCallbackHandler().handle(new Callback[]{nc, pc});
                    ArrayList<Parameter> params = new ArrayList<Parameter>();
                    params.add(new Parameter("host", (Object)lcd.getHostname()));
                    params.add(new Parameter("port", (Object)lcd.getPortNumber()));
                    switch (lcd.getAuthenticationMethod()) {
                        case SIMPLE: {
                            params.add(new Parameter("auth", (Object)"simple"));
                            params.add(new Parameter("user", (Object)nc.getName()));
                            params.add(new Parameter("password", (Object)new String(pc.getPassword())));
                        }
                    }
                    params.add(new Parameter("baseDN", (Object)lcd.getBaseDN()));
                    params.add(new Parameter("scope", (Object)"subtree"));
                    params.add(new Parameter("exportPoint", (Object)dn));
                    String path = chooser.getSelectedFile().getCanonicalPath();
                    if (!path.endsWith(".ldif")) {
                        path = path + ".ldif";
                    }
                    File temp = File.createTempFile("openthinclient-export-", ".ldif");
                    params.add(new Parameter("file", (Object)temp.getPath()));
                    params.add(new Parameter("debug", (Object)true));
                    params.add(new Parameter("verbose", (Object)true));
                    final ProgressHandle handle = ProgressHandleFactory.createHandle((String)"LDIF export");
                    ListenerParameter[] listeners = new ListenerParameter[]{new ListenerParameter("exceptionListener", new ToolCommandListener(){

                        public void notify(Serializable o) {
                            ErrorManager.getDefault().annotate((Throwable)o, "Exception during LDIF export");
                            ErrorManager.getDefault().notify((Throwable)o);
                        }
                    }), new ListenerParameter("ouputListener", new ToolCommandListener(){

                        public void notify(Serializable o) {
                            handle.progress(o.toString());
                        }
                    }), new ListenerParameter("errorListener", new ToolCommandListener(){

                        public void notify(Serializable o) {
                            IOException e = new IOException(o.toString());
                            ErrorManager.getDefault().annotate((Throwable)e, "Error during LDIF export");
                            ErrorManager.getDefault().notify((Throwable)o);
                        }
                    })};
                    handle.start();
                    try {
                        ExportCommandExecutor ex = new ExportCommandExecutor();
                        ex.execute(params.toArray(new Parameter[params.size()]), listeners);
                    }
                    finally {
                        handle.finish();
                        DirectoryEntryNode.createExportFile(temp, path, lcd.getBaseDN(), bar);
                        bar.finished(Messages.getString("LdifExportPanel.name"), Messages.getString("LdifExportPanel.text"));
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"Could not export", t);
                    bar.finished("LdifExportPanel.name", t.toString());
                }
            }
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1 && activatedNodes[0] instanceof DirectoryEntryNode;
        }
    }
}

