/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.PropertyValidationSupport;
import javax.swing.JPanel;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.console.Messages;
import org.openthinclient.console.util.DetailViewFormBuilder;

public class UserEditor
extends JPanel {
    public UserEditor(User user, Realm realm) {
        if (!LDAPDirectory.isMutable(User.class)) {
            PresentationModel model = new PresentationModel((ValueModel)new ValueHolder((Object)user, true));
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("r:p, 3dlu, f:p:g"), Messages.getBundle(), this);
            dfb.getPanel().setName(Messages.getString("Settings_title"));
            dfb.appendI15d("User.givenName", BasicComponentFactory.createLabel((ValueModel)model.getModel("givenName")));
            dfb.nextLine();
            dfb.appendI15d("User.surname", BasicComponentFactory.createLabel((ValueModel)model.getModel("sn")));
            dfb.nextLine();
            dfb.appendUnrelatedComponentsGapRow();
            dfb.nextLine();
            dfb.appendI15d("User.changePassword", BasicComponentFactory.createLabel((ValueModel)model.getModel("newPassword")));
            dfb.nextLine();
            dfb.appendI15d("User.verifyPassword", BasicComponentFactory.createLabel((ValueModel)model.getModel("verifyPassword")));
            dfb.nextLine();
            this.putClientProperty("validator", new UserValidator(model, user));
        } else {
            PresentationModel model = new PresentationModel((ValueModel)new ValueHolder((Object)user, true));
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("r:p, 3dlu, f:p:g"), Messages.getBundle(), this);
            dfb.getPanel().setName(Messages.getString("Settings_title"));
            dfb.appendI15d("User.givenName", BasicComponentFactory.createTextField((ValueModel)model.getModel("givenName"), (boolean)true));
            dfb.nextLine();
            dfb.appendI15d("User.surname", BasicComponentFactory.createTextField((ValueModel)model.getModel("sn"), (boolean)false));
            dfb.nextLine();
            dfb.appendUnrelatedComponentsGapRow();
            dfb.nextLine();
            dfb.appendI15d("User.changePassword", BasicComponentFactory.createPasswordField((ValueModel)model.getModel("newPassword"), (boolean)false));
            dfb.nextLine();
            dfb.appendI15d("User.verifyPassword", BasicComponentFactory.createPasswordField((ValueModel)model.getModel("verifyPassword"), (boolean)false));
            dfb.nextLine();
            this.putClientProperty("validator", new UserValidator(model, user));
        }
    }

    private static class UserValidator
    implements Validator {
        private final User user;
        private final PresentationModel model;

        UserValidator(PresentationModel model, User user) {
            this.model = model;
            this.user = user;
        }

        public ValidationResult validate() {
            this.model.triggerCommit();
            PropertyValidationSupport support = new PropertyValidationSupport((Object)this.user, "User");
            if (null == this.user.getSn() || this.user.getSn().equals("")) {
                support.addError("surname", Messages.getString("UserEditor.validation.surname.mandatory"));
            }
            if (null != this.user.getNewPassword() && !this.user.getNewPassword().equals(this.user.getVerifyPassword())) {
                support.addError("password", Messages.getString("UserEditor.validation.password.mismatch"));
            }
            return support.getResult();
        }
    }
}

