/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.openthinclient.console.util.SectionTitleBar;

public class CollapsibleTitlePanel
extends JPanel
implements Scrollable {
    private static final String BOTTOM_INDENT = "8dlu";
    private static final String LEFT_INDENT = "10dlu";
    private Color titleBackgroundColor;
    private Color titleForegroundColor;
    private Color separatorColor;
    private JXHyperlink link;
    private JXCollapsiblePane collapsible;

    public CollapsibleTitlePanel(String title, Component component, boolean withTitleBackground) {
        FormLayout layout = new FormLayout("0dlu, fill:default:grow", "2dlu, default, 0dlu, fill:default:grow, 0dlu");
        this.setLayout((LayoutManager)layout);
        this.setOpaque(false);
        FormLayout collapsibleLayout = new FormLayout("10dlu, fill:default:grow", "fill:default:grow, 8dlu");
        CellConstraints cc = new CellConstraints();
        this.collapsible = new JXCollapsiblePane();
        this.collapsible.setAnimated(false);
        this.collapsible.getContentPane().setLayout((LayoutManager)collapsibleLayout);
        this.collapsible.getContentPane().add(component, cc.xy(2, 1));
        this.collapsible.setOpaque(false);
        ((JPanel)this.collapsible.getContentPane()).setOpaque(false);
        ((JPanel)this.collapsible.getComponent(0)).setOpaque(false);
        Action toggleAction = this.collapsible.getActionMap().get("toggle");
        toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon"));
        toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon"));
        this.link = new JXHyperlink(toggleAction);
        this.link.setText(title);
        this.link.setFont(this.link.getFont().deriveFont(1));
        this.link.setOpaque(false);
        this.link.setFocusPainted(false);
        this.link.setUnclickedColor(this.getTitleForegroundColor());
        this.link.setClickedColor(this.getTitleForegroundColor());
        if (withTitleBackground) {
            SectionTitleBar titleBar = new SectionTitleBar();
            titleBar.add((Component)this.link);
            this.add((Component)titleBar, cc.xy(2, 2));
        } else {
            this.add((Component)this.link, cc.xy(2, 2));
        }
        this.add((Component)this.collapsible, cc.xywh(1, 4, 2, 2));
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public Color getTitleForegroundColor() {
        return this.titleForegroundColor;
    }

    public void setTitleForegroundColor(Color titleForegroundColor) {
        this.titleForegroundColor = titleForegroundColor;
    }

    public Color getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleBackgroundColor(Color titleBackgroundColor) {
        this.titleBackgroundColor = titleBackgroundColor;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.link != null) {
            this.link.setOpaque(isOpaque);
        }
        if (this.collapsible != null) {
            this.collapsible.setOpaque(isOpaque);
        }
    }

    class SeparatorBorder
    implements Border {
        SeparatorBorder() {
        }

        boolean isFirst(Component c) {
            return c.getParent() == null || c.getParent().getComponent(0) == c;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (c instanceof JXCollapsiblePane && ((JXCollapsiblePane)c).isCollapsed()) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(this.isFirst(c) ? 4 : 1, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(CollapsibleTitlePanel.this.getSeparatorColor());
            if (this.isFirst(c)) {
                g.drawLine(x, y + 2, x + width, y + 2);
            }
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }
}

