/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.Messages;
import org.openthinclient.console.util.ChildValidator;

public class DirObjectEditPanel
extends JPanel {
    private final ChildValidator validator = new ChildValidator();
    private final ValidationResultModel vrm = new DefaultValidationResultModel();

    public DirObjectEditPanel(DetailView detailView) {
        this.setLayout((LayoutManager)new FormLayout("p:g", "p, 3dlu, f:p:g, 3dlu, p, 3dlu"));
        CellConstraints cc = new CellConstraints();
        JComponent headerComponent = detailView.getHeaderComponent();
        if (null != headerComponent) {
            headerComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker()), headerComponent.getBorder()));
            this.validator.addValidatorFrom(headerComponent);
            this.add((Component)headerComponent, cc.xy(1, 1));
        }
        this.add((Component)ValidationResultViewFactory.createReportIconAndTextPane((ValidationResultModel)this.vrm), cc.xy(1, 5));
        JComponent mainComponent = detailView.getMainComponent();
        this.validator.addValidatorFrom(mainComponent);
        this.add((Component)mainComponent, cc.xy(1, 3));
        this.setPreferredSize(new Dimension(800, 600));
    }

    public boolean doEdit(DirectoryObject dirObject, Node node) {
        final JButton okButton = new JButton(Messages.getString("OK"));
        JButton cancelButton = new JButton(Messages.getString("Cancel"));
        String name = node.getDisplayName().replace("()", "").trim();
        String simpleClassName = dirObject.getClass().getSimpleName();
        String title = MessageFormat.format(Messages.getString("DirObjectEditPanel.title"), Messages.getString("types.singular." + simpleClassName), name);
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, title, true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, null, null);
        this.doValidate(okButton);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirObjectEditPanel.this.doValidate(okButton);
            }
        };
        dirObject.addPropertyChangeListener(pcl);
        dialog.setSize(830, 600);
        dialog.setPreferredSize(new Dimension(830, 600));
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - dialog.getWidth()) / 2, (screenSize.height - dialog.getHeight()) / 2);
        dialog.setVisible(true);
        dialog.toFront();
        dirObject.removePropertyChangeListener(pcl);
        return descriptor.getValue() == okButton;
    }

    private void doValidate(JButton okButton) {
        ValidationResult validate = this.validator.validate();
        okButton.setEnabled(!validate.hasErrors());
        this.revalidate();
        this.vrm.setResult(validate);
    }
}

