/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import java.util.ArrayList;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.console.Messages;

public class DirObjectsTableModel
extends AbstractTableModel {
    protected ArrayList<DirectoryObject> dirObjects = new ArrayList();
    protected String[] columnNames;

    public DirObjectsTableModel(Set<? extends DirectoryObject> other) {
        String columns;
        if (other != null) {
            for (DirectoryObject directoryObject : other) {
                this.dirObjects.add(directoryObject);
            }
        }
        if ((columns = Messages.getString("table.DirObjects")) != null) {
            this.columnNames = columns.split(",");
        }
    }

    public DirObjectsTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.dirObjects.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DirectoryObject object = this.dirObjects.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return object.getName();
            }
            case 1: {
                return object.getDescription();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int index) {
        if (this.columnNames != null) {
            return this.columnNames[index];
        }
        return null;
    }

    public void addDirectoryObject(DirectoryObject newObj) {
        if (!this.dirObjects.contains(newObj)) {
            this.dirObjects.add(newObj);
            this.fireTableRowsInserted(this.dirObjects.size() - 1, this.dirObjects.size() - 1);
        }
    }

    public void removeDirectoryObjectAt(int index) {
        if (this.dirObjects.remove(index) != null) {
            this.fireTableRowsDeleted(index, index);
        }
    }

    public DirectoryObject getDirectoryObjectAt(int row) {
        return this.dirObjects.get(row);
    }

    public ArrayList<? extends DirectoryObject> getDirectoryObjects() {
        return this.dirObjects;
    }
}

