/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import com.levigo.util.log.Logger;
import com.levigo.util.log.LoggerFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class TitleComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static final BufferedImage TITLE_LOGO;
    private static final BufferedImage TITLE_BACKGROUND;
    private static final Dimension PREFERRED_SIZE;
    private String title;
    private transient GlyphVector preparedTitle;

    public TitleComponent() {
        this.setFont(new Font("dialog", 0, 20));
        this.setForeground(Color.WHITE);
    }

    public TitleComponent(String title) {
        this();
        this.title = title;
        this.preparedTitle = null;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.preparedTitle = null;
    }

    @Override
    public Dimension getPreferredSize() {
        GlyphVector glv = this.getPreparedTitle();
        if (glv != null) {
            Rectangle2D visualBounds = glv.getVisualBounds();
            int width = (int)((double)TitleComponent.PREFERRED_SIZE.width + visualBounds.getX() + visualBounds.getWidth()) + 10;
            return new Dimension(width, TitleComponent.PREFERRED_SIZE.height);
        }
        return PREFERRED_SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    protected GlyphVector getPreparedTitle() {
        if (this.preparedTitle == null && this.title != null && this.title.trim().length() != 0) {
            this.preparedTitle = this.getFont().createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), this.title);
        }
        return this.preparedTitle;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform transform = g2d.getTransform();
        double scaleX = this.getSize().getWidth() / (double)TITLE_BACKGROUND.getWidth();
        g2d.scale(scaleX, 1.0);
        g2d.drawImage(TITLE_BACKGROUND, null, 0, 0);
        g2d.setTransform(transform);
        g2d.drawImage(TITLE_LOGO, null, 0, 0);
        GlyphVector glv = this.getPreparedTitle();
        if (glv != null) {
            g2d.setColor(this.getForeground());
            Rectangle2D visualBounds = glv.getVisualBounds();
            int x = TITLE_LOGO.getWidth();
            float y = (float)((double)(TITLE_LOGO.getHeight() / 2) - visualBounds.getHeight() / 2.0 - visualBounds.getY());
            g2d.drawGlyphVector(glv, x, y);
        }
    }

    static {
        BufferedImage backgroundSlice;
        BufferedImage logo;
        LOG = LoggerFactory.getLogger(TitleComponent.class);
        try {
            logo = ImageIO.read(TitleComponent.class.getResource("otc_toplogo.png"));
            backgroundSlice = new BufferedImage(2, logo.getHeight(), logo.getType());
            Graphics2D g2d = backgroundSlice.createGraphics();
            g2d.drawImage(logo, null, 0, 0);
            g2d.dispose();
        }
        catch (Exception e) {
            LOG.error("Failed to load title logo.", (Throwable)e);
            logo = new BufferedImage(1, 1, 2);
            backgroundSlice = new BufferedImage(1, 1, 2);
        }
        TITLE_LOGO = logo;
        PREFERRED_SIZE = new Dimension(TITLE_LOGO.getWidth(), TITLE_LOGO.getHeight());
        TITLE_BACKGROUND = backgroundSlice;
    }
}

