/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui.fields;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.openide.awt.StatusDisplayer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Node;

public abstract class ConfigField {
    private static MyFocusListener myFocusListener = new MyFocusListener();
    protected Node node;
    protected final Profile profile;

    protected ConfigField(Profile profile, Node node) {
        this.profile = profile;
        this.node = node;
    }

    protected abstract JComponent getMainComponent();

    public JComponent getEditor() {
        JComponent mainComponent = this.getMainComponent();
        mainComponent.setToolTipText(this.node.getTip());
        mainComponent.addFocusListener(myFocusListener);
        return mainComponent;
    }

    public boolean isValueOverridden() {
        return this.profile.containsValue(this.node.getKey());
    }

    public void resetValueToDefault() {
        this.profile.removeValue(this.node.getKey());
        this.updateRepresentation();
    }

    protected void updateRepresentation() {
    }

    protected String valueToDisplayedValue(String value) {
        return value;
    }

    protected void setValue(String value) {
        if (null == this.profile.getValue(this.node.getKey()) || !this.profile.getValue(this.node.getKey()).equals(value)) {
            this.profile.setValue(this.node.getKey(), value);
        }
        this.updateRepresentation();
    }

    private static class MyFocusListener
    implements FocusListener {
        private String didSetThisText = null;

        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            String ttt = ((JComponent)e.getSource()).getToolTipText();
            StatusDisplayer.getDefault().setStatusText(null != ttt ? ttt : "");
            this.didSetThisText = ttt;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (null != this.didSetThisText && this.didSetThisText.equals(StatusDisplayer.getDefault().getStatusText())) {
                StatusDisplayer.getDefault().setStatusText("");
            }
            this.didSetThisText = null;
        }
    }
}

