/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui.fields;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.fields.ConfigField;

public class EntryField
extends ConfigField {
    private JTextField textField = new JTextField();

    public EntryField(Profile profile, EntryNode n) {
        super(profile, (Node)n);
        if (n.getKey().equals("Serversettings.Hostname") || n.getKey().equals("Serversettings.Portnumber")) {
            this.textField.setEditable(false);
        }
        this.updateRepresentation();
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String v = EntryField.this.textField.getText();
                if (v.length() > 0) {
                    EntryField.this.setValue(v);
                } else {
                    EntryField.this.resetValueToDefault();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                EntryField.this.updateRepresentation();
            }
        });
    }

    @Override
    protected void updateRepresentation() {
        String text;
        String k = this.node.getKey();
        String value = this.profile.getValue(k);
        boolean containsValue = this.profile.containsValue(k);
        String definingProfile = this.profile.getDefiningProfile(k, true);
        if (containsValue || this.textField.hasFocus()) {
            this.textField.setForeground(UIManager.getColor("TextField.foreground"));
            if (this.textField.hasFocus()) {
                text = containsValue && null != value ? value : "";
            } else {
                text = value;
                String overriddenValue = this.profile.getOverriddenValue(k);
                if (null != overriddenValue) {
                    text = text + " " + Messages.getString("EntryField.overrides", overriddenValue, definingProfile);
                }
            }
        } else {
            this.textField.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            text = null != value ? value + " " + Messages.getString("EntryField.defaultFrom", definingProfile) : Messages.getString("EntryField.noDefault");
        }
        this.textField.setText(text);
        super.updateRepresentation();
    }

    @Override
    protected JComponent getMainComponent() {
        return this.textField;
    }
}

