/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.initrealm;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openthinclient.console.Messages;
import org.openthinclient.console.wizards.ConnectionSettingsWizardPanel;
import org.openthinclient.console.wizards.initrealm.EnableableWizardPanel;
import org.openthinclient.console.wizards.initrealm.InitDefaultObjectsPanel;
import org.openthinclient.console.wizards.initrealm.InitEnvironmentPanel;
import org.openthinclient.console.wizards.initrealm.OtherDSNoticePanel;
import org.openthinclient.console.wizards.initrealm.SelectBasePanel;
import org.openthinclient.console.wizards.initrealm.SelectRegistrationPanel;
import org.openthinclient.console.wizards.initrealm.SetupADSACIPanel;

public final class NewRealmInitWizardIterator
implements WizardDescriptor.Iterator {
    private static int index;
    private List<WizardDescriptor.Panel> availablePanels = new ArrayList<WizardDescriptor.Panel>();
    private static List<WizardDescriptor.Panel> activePanels;
    private List<WizardDescriptor.Panel> lastActivePanels = new ArrayList<WizardDescriptor.Panel>();
    private WizardDescriptor wizardDescriptor;
    private transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewRealmInitWizardIterator() {
        index = 0;
        ConnectionSettingsWizardPanel connectionSettingsWizardPanel = new ConnectionSettingsWizardPanel();
        connectionSettingsWizardPanel.getComponent().putClientProperty("WizardPanel_errorMessage", Messages.getString("NewRealmInit_baseDN_host_error"));
        this.availablePanels.add((WizardDescriptor.Panel)connectionSettingsWizardPanel);
        this.availablePanels.add(new SelectBasePanel());
        this.availablePanels.add(new InitEnvironmentPanel());
        this.availablePanels.add(new InitDefaultObjectsPanel());
        this.availablePanels.add(new SetupADSACIPanel());
        this.availablePanels.add(new OtherDSNoticePanel());
        this.availablePanels.add(new SelectRegistrationPanel());
        this.initPanels();
        this.updateActivePanels();
    }

    private void initPanels() {
        for (WizardDescriptor.Panel panel : this.availablePanels) {
            Component c = panel.getComponent();
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NewRealmInitWizardIterator.this.updateActivePanels();
                }
            });
        }
    }

    private boolean updateActivePanels() {
        activePanels.clear();
        ArrayList<String> stepNames = new ArrayList<String>();
        for (WizardDescriptor.Panel panel : this.availablePanels) {
            if (panel instanceof EnableableWizardPanel && !((EnableableWizardPanel)panel).isEnabled(this.wizardDescriptor)) continue;
            activePanels.add(panel);
            stepNames.add(panel.getComponent().getName());
        }
        String[] stepNamesA = stepNames.toArray(new String[stepNames.size()]);
        int i = 0;
        for (WizardDescriptor.Panel panel : activePanels) {
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentData", stepNamesA);
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_errorMessage", Messages.getString("NewRealmInit_baseDN_host_error"));
            ++i;
        }
        if (!activePanels.equals(this.lastActivePanels)) {
            this.lastActivePanels.clear();
            this.lastActivePanels.addAll(activePanels);
            return true;
        }
        return false;
    }

    public WizardDescriptor.Panel current() {
        return activePanels.get(index);
    }

    public static WizardDescriptor.Panel current(int index) {
        return activePanels.get(index);
    }

    public String name() {
        return Messages.getString("Wizards.xofy", index + 1, activePanels.size());
    }

    public boolean hasNext() {
        return index < activePanels.size() - 1;
    }

    public boolean hasPrevious() {
        return index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet<ChangeListener>(1);
    }

    public void setWizardDescriptor(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public static int getIndex() {
        return index;
    }

    public static void setIndex(int index) {
        NewRealmInitWizardIterator.index = index;
    }

    static {
        activePanels = new ArrayList<WizardDescriptor.Panel>();
    }
}

