/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.initrealm;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirectoryEntryNode;
import org.openthinclient.console.nodes.DirectoryNode;
import org.openthinclient.console.nodes.DirectoryViewNode;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class SelectBasePanel
implements WizardDescriptor.Panel {
    private final ExplorerManager manager = new ExplorerManager();
    private LDAPConnectionDescriptor connectionDescriptor;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JCheckBox newFolderBox;
    private JPanel component;
    private WizardDescriptor wizardDescriptor;
    private final NodeAdapter nodeEventForwarder = new NodeAdapter(){

        public void childrenRemoved(NodeMemberEvent e) {
            this.forward();
        }

        private void forward() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectBasePanel.this.fireChangeEvent();
                }
            });
        }

        public void childrenAdded(NodeMemberEvent e) {
            this.forward();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public JComponent getComponent() {
        if (null == this.component) {
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("f:p:g"), Messages.getBundle(), (JPanel)new MyPanel());
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SelectBasePanel.this.fireChangeEvent();
                }
            });
            ActionListener changeForwarder = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectBasePanel.this.updateComponentStates();
                    SelectBasePanel.this.fireChangeEvent();
                }
            };
            dfb.appendI15dTitle("NewRealmInit.select_location");
            dfb.nextLine();
            BeanTreeView view = new BeanTreeView();
            view.setDefaultActionAllowed(false);
            view.setRootVisible(true);
            dfb.appendRow("min(140dlu;pref)");
            dfb.append((Component)view);
            dfb.nextLine();
            this.newFolderBox = new JCheckBox();
            this.newFolderBox.setText(Messages.getString("NewRealmInit.new_folder.checkBox"));
            this.newFolderBox.setVerticalTextPosition(1);
            this.newFolderBox.addActionListener(changeForwarder);
            this.newFolderBox.setSelected(true);
            dfb.append((Component)this.newFolderBox, dfb.getColumnCount());
            dfb.nextLine();
            this.component = dfb.getPanel();
            this.component.setName(Messages.getString("NewRealmInit.name"));
            this.updateComponentStates();
        }
        return this.component;
    }

    protected void updateComponentStates() {
        if (null != this.wizardDescriptor) {
            this.wizardDescriptor.putProperty("newFolderBox", (Object)this.newFolderBox.isSelected());
        }
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getSelectedBaseDN() {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length > 0 && selectedNodes[0] instanceof DirectoryEntryNode) {
            return ((DirectoryEntryNode)selectedNodes[0]).getDn();
        }
        return null;
    }

    public boolean isValid() {
        if (this.manager.getSelectedNodes().length != 1 || this.getSelectedBaseDN() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewRealmInit.validation.error.no_node_selected"));
            return false;
        }
        DirectoryEntryNode den = (DirectoryEntryNode)this.manager.getSelectedNodes()[0];
        if (!this.newFolderBox.isSelected() && this.getSelectedBaseDN().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewRealmInit.validation.error.no_node_selected"));
            return false;
        }
        if (den.getChildren().getNodes().length != 0 && !this.newFolderBox.isSelected()) {
            den.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this.nodeEventForwarder, (Object)den));
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewRealmInit.validation.error.path_not_empty"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.connectionDescriptor = (LDAPConnectionDescriptor)this.wizardDescriptor.getProperty("connectionDescriptor");
        this.updateComponentStates();
        DetailViewProvider root = !this.connectionDescriptor.isBaseDnSet() ? new DirectoryNode(this.connectionDescriptor) : new DirectoryViewNode(this.connectionDescriptor);
        this.manager.setRootContext((Node)root);
        try {
            this.manager.setSelectedNodes(new Node[]{root});
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        wd.putProperty("newFolderBox", (Object)this.newFolderBox.isSelected());
        wd.putProperty("oldSelectedBaseDN", (Object)this.getSelectedBaseDN());
    }

    private class MyPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private MyPanel() {
        }

        public ExplorerManager getExplorerManager() {
            return SelectBasePanel.this.manager;
        }
    }
}

