/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.initrealm;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openthinclient.console.Messages;
import org.openthinclient.console.wizards.initrealm.EnableableWizardPanel;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Util;

public class SetupADSACIPanel
implements WizardDescriptor.Panel,
EnableableWizardPanel {
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JPanel component;
    private WizardDescriptor wizardDescriptor;
    private String baseDN;
    private JCheckBox baseCheckBox;
    private JCheckBox searchForAllCheckBox;
    private JCheckBox adminAccessCheckBox;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public JComponent getComponent() {
        if (null == this.component) {
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("15dlu, 15dlu, fill:max(200dlu;pref)"), Messages.getBundle());
            ActionListener changeForwarder = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetupADSACIPanel.this.updateComponentStates();
                    SetupADSACIPanel.this.fireChangeEvent();
                }
            };
            this.baseCheckBox = new JCheckBox();
            this.baseCheckBox.setVerticalTextPosition(1);
            this.baseCheckBox.setSelected(true);
            this.baseCheckBox.addActionListener(changeForwarder);
            dfb.append((Component)this.baseCheckBox, dfb.getColumnCount());
            dfb.nextLine();
            dfb.setLeadingColumnOffset(1);
            this.adminAccessCheckBox = new JCheckBox();
            this.adminAccessCheckBox.setVerticalAlignment(1);
            this.adminAccessCheckBox.setVerticalTextPosition(1);
            this.adminAccessCheckBox.addActionListener(changeForwarder);
            this.adminAccessCheckBox.setSelected(true);
            dfb.append((Component)this.adminAccessCheckBox, 2);
            dfb.nextLine();
            this.searchForAllCheckBox = new JCheckBox();
            this.searchForAllCheckBox.setVerticalTextPosition(1);
            this.searchForAllCheckBox.setSelected(true);
            dfb.append((Component)this.searchForAllCheckBox, 2);
            dfb.nextLine();
            this.updateComponentStates();
            this.component = dfb.getPanel();
            this.component.setName(Messages.getString("SetupADSACIPanel.name"));
        }
        return this.component;
    }

    protected void updateComponentStates() {
        this.baseCheckBox.setText(Messages.getString("SetupADSACIPanel.base", this.baseDN));
        boolean enabled = this.baseCheckBox.isSelected();
        this.searchForAllCheckBox.setEnabled(enabled);
        this.searchForAllCheckBox.setText(Messages.getString("SetupADSACIPanel.enableSearchForAll", this.baseDN));
        this.adminAccessCheckBox.setEnabled(enabled);
        this.adminAccessCheckBox.setText(Messages.getString("SetupADSACIPanel.enableAdminAccess", this.baseDN));
        if (null != this.wizardDescriptor) {
            this.wizardDescriptor.putProperty("ACISetupTakenCareOf", (Object)this.baseCheckBox.isSelected());
        }
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.baseDN = (String)this.wizardDescriptor.getProperty("selectedBaseDN");
        this.updateComponentStates();
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        wd.putProperty("createADSACIs", (Object)this.baseCheckBox.isSelected());
        wd.putProperty("enableSearchForAll", (Object)this.searchForAllCheckBox.isSelected());
        wd.putProperty("enableAdminAccess", (Object)this.adminAccessCheckBox.isSelected());
    }

    @Override
    public boolean isEnabled(WizardDescriptor wd) {
        if (null == wd) {
            return false;
        }
        LDAPConnectionDescriptor.DirectoryType serverType = (LDAPConnectionDescriptor.DirectoryType)wd.getProperty("serverType");
        if (null != serverType && serverType == LDAPConnectionDescriptor.DirectoryType.APACHE_DS) {
            try {
                DirContext ctx = (DirContext)wd.getProperty("schema");
                boolean isADS = Util.hasObjectClass((DirContext)ctx, (String)"apacheCatalogEntry");
                return isADS;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return false;
    }
}

