/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.newdirobject;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.nodes.RealmsNode;

public class SelectObjectTypePanel
extends JPanel
implements WizardDescriptor.Panel {
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JComboBox realmComboBox;
    private final ArrayList<Realm> realms = new ArrayList();
    private JComboBox typeComboBox;
    private WizardDescriptor wd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void initComponents() {
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("r:p,3dlu,f:p:g,3dlu,p,3dlu,p"), Messages.getBundle(), (JPanel)this);
        String[] types = Messages.getString("NewDirObject.SelectObjectTypePanel.type_dropdown_types").split("\\s*,\\s*");
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            try {
                classes[i] = Class.forName(types[i]);
                continue;
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
        this.typeComboBox = new JComboBox<String>(types);
        this.typeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String v = value.toString();
                v = v.substring(v.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent((JList<?>)list, Messages.getString("NewDirObject.SelectObjectTypePanel.dropdown_item." + v), index, isSelected, cellHasFocus);
            }
        });
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectObjectTypePanel.this.fireChangeEvent();
            }
        });
        this.realmComboBox = new JComboBox<Object>(this.realms.toArray());
        this.realmComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectObjectTypePanel.this.fireChangeEvent();
            }
        });
        dfb.appendI15d("NewDirObject.SelectObjectTypePanel.realm_label", (Component)this.realmComboBox);
        dfb.nextLine();
        dfb.appendI15d("NewDirObject.SelectObjectTypePanel.type_label", (Component)this.typeComboBox);
        dfb.nextLine();
    }

    @Override
    public boolean isValid() {
        if (this.typeComboBox.getSelectedItem() == null) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewDirObject.SelectObjectTypePanel.type_error"));
            return false;
        }
        if (this.realmComboBox.getSelectedItem() == null) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewDirObject.SelectObjectTypePanel.realm_error"));
            return false;
        }
        return true;
    }

    private Realm[] loadRealms() {
        Node[] childNodes;
        Realm[] realms = null;
        Node rootNode = MainTreeTopComponent.getDefault().getExplorerManager().getRootContext();
        for (Node node : childNodes = rootNode.getChildren().getNodes()) {
            if (!(node instanceof RealmsNode)) continue;
            Node[] realmNodes = node.getChildren().getNodes(true);
            realms = new Realm[realmNodes.length];
            int i = 0;
            for (Node realmNode : realmNodes) {
                Realm realm;
                if (!(realmNode instanceof RealmNode)) continue;
                RealmNode currNode = (RealmNode)realmNode;
                realms[i] = realm = (Realm)currNode.getLookup().lookup(Realm.class);
                ++i;
            }
        }
        return realms;
    }

    public SelectObjectTypePanel() {
        this.setName(Messages.getString("NewDirObject.SelectObjectTypePanel.name"));
        Realm[] arrayRealm = this.loadRealms();
        for (int i = 0; arrayRealm.length > i; ++i) {
            this.realms.add(arrayRealm[i]);
        }
        this.initComponents();
    }

    public void readSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.realmComboBox.setSelectedItem(this.wd.getProperty("realm"));
        this.typeComboBox.setSelectedItem(this.wd.getProperty("type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.wd.putProperty("type", this.typeComboBox.getSelectedItem());
        this.wd.putProperty("realm", this.realmComboBox.getSelectedItem());
    }
}

