/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.util.prefs.BackingStoreException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.CallbackHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.directory.ACLUtils;
import org.openthinclient.common.model.OrganizationalUnit;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.RealmManager;
import org.openthinclient.console.configuration.ContextRegistry;
import org.openthinclient.console.util.UsernamePasswordCallbackHandler;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Util;
import org.openthinclient.services.Dhcp;

public class DeleteRealmAction
extends NodeAction {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodes) {
        boolean delete = false;
        boolean ask = true;
        if (nodes.length > 1) {
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.deleteReally.question2", nodes.length), 0)) == NotifyDescriptor.YES_OPTION) {
                delete = true;
            }
            ask = false;
        }
        for (Node node : nodes) {
            if (!(node instanceof EditorProvider)) continue;
            Realm realm = (Realm)node.getLookup().lookup(Realm.class);
            LDAPConnectionDescriptor lcd = realm.getConnectionDescriptor();
            try {
                if (ask && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.deleteReally.question1", "\"" + node.getName() + "\""), 0)) == NotifyDescriptor.YES_OPTION) {
                    delete = true;
                }
                if (!delete) continue;
                DirectoryFacade df = lcd.createDirectoryFacade();
                try (LdapContext ctx = df.createDirContext();){
                    Util.deleteRecursively((DirContext)ctx, (Name)df.makeRelativeName(""));
                    Dhcp dhcpService = (Dhcp)ContextRegistry.INSTANCE.getContext(realm).getBean(Dhcp.class);
                    if (!dhcpService.reloadRealms()) {
                        ErrorManager.getDefault().notify(new Throwable("dhcpService.dhcpReloadRealms() failed"));
                    }
                    LdapContext ctxLdap = lcd.createDirectoryFacade().createDirContext();
                    ACLUtils utils = new ACLUtils(ctxLdap);
                    utils.deleteACI("", "enableAdmins");
                    utils.deleteACI("", "enableSearchForAllUsers");
                    OrganizationalUnit ou = new OrganizationalUnit();
                    ou.setDn(lcd.getBaseDN());
                    realm.getDirectory().delete((Object)ou);
                    node.destroy();
                    String realmName = lcd.getHostname() + lcd.getBaseDN();
                    CallbackHandler handler = lcd.getCallbackHandler();
                    UsernamePasswordCallbackHandler call = (UsernamePasswordCallbackHandler)((Object)handler);
                    try {
                        RealmManager.deregisterRealm(realmName);
                        call.deleteCredentials();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                        ErrorManager.getDefault().notify((Throwable)e1);
                    }
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean enable(Node[] arg0) {
        return true;
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

