/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Properties;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;

public class DuplicateAction
extends NodeAction {
    protected boolean asynchronous() {
        return true;
    }

    protected void performAction(Node[] arg0) {
        HashSet<Node> parentNodesToRefresh = new HashSet<Node>();
        for (Node node : arg0) {
            DirectoryObject dirObject = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
            Realm realm = (Realm)node.getLookup().lookup(Realm.class);
            try {
                DirectoryObject copyObj = (DirectoryObject)dirObject.getClass().newInstance();
                String duplicateName = Messages.getString("DuplicateOf", dirObject.getName());
                copyObj.setName(duplicateName);
                if (dirObject instanceof Profile) {
                    ((Profile)copyObj).getProperties().setDescription(((Profile)dirObject).getProperties().getDescription());
                    Properties props = ((Profile)dirObject).getProperties();
                    SortedMap pmap = props.getMap();
                    for (Map.Entry e : pmap.entrySet()) {
                        ((Profile)copyObj).setValue((String)e.getKey(), (String)e.getValue());
                    }
                }
                copyObj.setDescription(dirObject.getDescription());
                realm.getDirectory().save((Object)copyObj);
                Node parentNode = node.getParentNode();
                if (null == parentNode || !(parentNode instanceof Refreshable)) continue;
                parentNodesToRefresh.add(parentNode);
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        for (Node node : parentNodesToRefresh) {
            ((Refreshable)node).refresh();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Class currentClass = (Class)node.getLookup().lookup(Class.class);
            if (LDAPDirectory.isMutable((Class)currentClass)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

