/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.configuration.HttpInvokerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ContextRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegistry.class);
    public static final ContextRegistry INSTANCE = new ContextRegistry();
    public static final String PROPERTY_CODEBASE = System.getProperty("ThinClientManager.server.Codebase");
    private final Map<Realm, ApplicationContext> contexts = Collections.synchronizedMap(new WeakHashMap());

    public ApplicationContext getContext(Realm realm) {
        String homeServer;
        block10: {
            ApplicationContext existing = this.contexts.get(realm);
            if (existing != null) {
                return existing;
            }
            homeServer = null;
            if (null != realm.getSchemaProviderName()) {
                homeServer = realm.getSchemaProviderName();
            } else if (null != realm.getConnectionDescriptor().getHostname()) {
                homeServer = realm.getConnectionDescriptor().getHostname();
            } else {
                try {
                    BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                    homeServer = basicService.getCodeBase().getHost();
                }
                catch (Exception e) {
                    LOG.warn("Failed to determine the codebase using the javax.jnlp.BasicService", (Throwable)e);
                    String codebaseProperty = PROPERTY_CODEBASE;
                    if (codebaseProperty != null) {
                        LOG.info("Using the system property '{}'. Value: '{}'", (Object)PROPERTY_CODEBASE, (Object)codebaseProperty);
                        try {
                            homeServer = new URL(codebaseProperty).getHost();
                        }
                        catch (MalformedURLException e1) {
                            LOG.error("Invalid url specified: {}", (Object)codebaseProperty);
                            homeServer = null;
                        }
                    }
                    if (homeServer != null) break block10;
                    LOG.warn("Falling back to localhost as the codebase URL");
                    homeServer = "localhost";
                }
            }
        }
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("manager.server.name", homeServer);
        ctx.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("dynamic", properties));
        ctx.register(new Class[]{HttpInvokerConfiguration.class});
        ctx.refresh();
        this.contexts.put(realm, (ApplicationContext)ctx);
        return ctx;
    }
}

