/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.AddRealmAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.wizards.registerrealm.RegisterRealmWizardIterator;

public class ServersNode
extends FilterNode {
    public ServersNode() throws DataObjectNotFoundException {
        super(DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Servers")).getNodeDelegate());
        this.getChildren().add(new Node[]{new ErrorNode(Messages.getString("ServersNode.notFound"))});
        this.disableDelegation(8);
    }

    public Action[] getActions(boolean popup) {
        DataFolder df = (DataFolder)this.getLookup().lookup(DataFolder.class);
        return new Action[]{new AddServerAction(df)};
    }

    public String getName() {
        return Messages.getString("node." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    private static class AddServerAction
    extends AbstractAction {
        private final DataFolder folder;

        public AddServerAction(DataFolder df) {
            super(Messages.getString("action." + AddServerAction.class.getSimpleName()));
            this.folder = df;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            RegisterRealmWizardIterator iterator = new RegisterRealmWizardIterator();
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
            wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
            wizardDescriptor.setTitle(Messages.getString("action." + AddRealmAction.class.getSimpleName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            dialog.setVisible(true);
            dialog.toFront();
            if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
                String baseName;
                Realm realm = (Realm)wizardDescriptor.getProperty("realm");
                assert (null != realm);
                FileObject fld = this.folder.getPrimaryFile();
                if (fld.getFileObject(baseName = "realm-" + realm.getDn(), "ser") != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Messages.getString("error.RealmAlreadyExists"), 2));
                    return;
                }
                try {
                    FileObject writeTo = fld.createData(baseName, "ser");
                    FileLock lock = writeTo.lock();
                    try (ObjectOutputStream str = new ObjectOutputStream(writeTo.getOutputStream(lock));){
                        str.writeObject(realm);
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }
}

