/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;

abstract class NBNodeTreeTableModel
extends AbstractTreeTableModel
implements NodeListener {
    private Set<Node> nodesListenedTo = new HashSet<Node>();

    public NBNodeTreeTableModel(Node node) {
        super((Object)node);
    }

    public abstract Object getValueAt(Object var1, int var2);

    public abstract String getColumnName(int var1);

    public void setValueAt(Object arg0, Object arg1, int arg2) {
        throw new IllegalArgumentException("not editable");
    }

    public abstract int getColumnCount();

    public Object getChild(Object parent, int idx) {
        return this.getNode(parent).getChildren().getNodes()[idx];
    }

    protected Node getNode(Object parent) {
        Node node = (Node)parent;
        if (!this.nodesListenedTo.contains(node)) {
            node.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)node));
            this.nodesListenedTo.add(node);
        }
        return node;
    }

    public int getChildCount(Object parent) {
        return this.getNode(parent).getChildren().getNodesCount();
    }

    public void childrenAdded(NodeMemberEvent ev) {
        this.fireTreeNodesInserted((Object)this, this.buildPath(ev.getNode()), ev.getDeltaIndices(), ev.getDelta());
    }

    private Object[] buildPath(Node node) {
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(node);
        while (path.get(0) != this.getRoot()) {
            Node parent = ((Node)path.get(0)).getParentNode();
            if (null == parent) {
                System.err.println("Unexpected: parent was null");
                break;
            }
            path.add(0, parent);
        }
        Object[] p = path.toArray(new Object[path.size()]);
        return p;
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        this.fireTreeNodesRemoved((Object)this, this.buildPath(ev.getNode()), ev.getDeltaIndices(), ev.getDelta());
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.fireTreeStructureChanged(ev, this.buildPath(ev.getNode()), ev.getPermutation(), new Node[0]);
    }

    public void nodeDestroyed(NodeEvent ev) {
        this.fireTreeNodesRemoved((Object)this, this.buildPath(ev.getNode().getParentNode()), new int[0], new Node[]{ev.getNode()});
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Node) {
            this.fireTreeNodesChanged((Object)this, this.buildPath((Node)evt.getSource()), new int[0], new Object[0]);
        }
    }
}

