/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.Messages;

public class ErrorPanel
extends JPanel {
    private final String title;
    private final String subtitle;
    private final String detail;
    private final Throwable t;
    private static final String BOTTOM_INDENT = "8dlu";
    private static final String LEFT_INDENT = "10dlu";

    public ErrorPanel(String title, String subtitle, String detail, Throwable t) {
        this.title = title;
        this.subtitle = subtitle;
        this.detail = detail;
        this.t = t;
        FormLayout layout = new FormLayout("pref, 3dlu, fill:default:grow", "2dlu, top:default, 2dlu, default, 0dlu, fill:default:grow, 0dlu");
        this.setLayout((LayoutManager)layout);
        this.setOpaque(false);
        Color foreground = UIManager.getColor("OptionPane.errorDialog.border.background");
        CellConstraints cc = new CellConstraints();
        JLabel icon = new JLabel(IconManager.getInstance(ConsoleFrame.class, (String)"icons").getIcon("tree.error"));
        this.add((Component)icon, cc.xy(1, 2));
        if (null == subtitle && null != t && null != t.getLocalizedMessage()) {
            subtitle = t.getLocalizedMessage();
        }
        JLabel titleLabel = new JLabel("<html><b>" + title + "</b>" + (null != subtitle ? "<p>" + subtitle : "") + "</html>");
        titleLabel.setForeground(foreground);
        this.add((Component)titleLabel, cc.xy(3, 2));
        JLabel detailLabel = null;
        if (null != detail || null != t) {
            StringBuilder sb = new StringBuilder();
            if (null != detail) {
                sb.append(detail);
            }
            if (null != t) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                sb.append(sw.toString());
            }
            String d = sb.toString();
            d = d.replaceAll("\n", "<br>\n");
            detailLabel = new JLabel("<html>" + d + "</html>");
            detailLabel.setForeground(foreground);
            FormLayout collapsibleLayout = new FormLayout("10dlu, fill:default:grow", "fill:default:grow, 8dlu");
            JXCollapsiblePane collapsible = new JXCollapsiblePane();
            collapsible.setAnimated(false);
            collapsible.getContentPane().setLayout((LayoutManager)collapsibleLayout);
            collapsible.getContentPane().add((Component)detailLabel, cc.xy(2, 1));
            collapsible.setOpaque(false);
            collapsible.setCollapsed(true);
            ((JPanel)collapsible.getContentPane()).setOpaque(false);
            ((JPanel)collapsible.getComponent(0)).setOpaque(false);
            Action toggleAction = collapsible.getActionMap().get("toggle");
            toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon"));
            toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon"));
            JXHyperlink link = new JXHyperlink(toggleAction);
            link.setText(Messages.getString("ErrorPanel.details"));
            link.setOpaque(false);
            link.setFocusPainted(false);
            link.setUnclickedColor(foreground);
            link.setClickedColor(foreground);
            this.add((Component)link, cc.xy(3, 4));
            this.add((Component)collapsible, cc.xy(3, 6));
        }
    }
}

