/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.util;

import com.jgoodies.forms.util.DefaultUnitConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class SectionTitleBar
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected JLabel titleLabel;

    public SectionTitleBar() {
        this.setLayout(new BoxLayout(this, 2));
        DefaultUnitConverter duc = DefaultUnitConverter.getInstance();
        int leftRight = duc.dialogUnitXAsPixel(4, (Component)this);
        int topBottom = duc.dialogUnitYAsPixel(2, (Component)this);
        this.setBorder(BorderFactory.createEmptyBorder(topBottom, leftRight, topBottom, leftRight));
        this.updateUI();
    }

    public SectionTitleBar(String title) {
        this();
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(UIManager.getFont("TitledBorder.font"));
        this.add(this.titleLabel);
        this.add(Box.createGlue());
        this.updateUI();
    }

    @Override
    protected void paintComponent(Graphics g) {
        DefaultUnitConverter duc = DefaultUnitConverter.getInstance();
        int w = this.getWidth() - 1;
        int h = this.getHeight();
        int bevelSize = duc.dialogUnitXAsPixel(6, (Component)this);
        Graphics2D g2 = (Graphics2D)g;
        GeneralPath clip = new GeneralPath();
        clip.moveTo(0.0f, h);
        clip.lineTo(0.0f, bevelSize);
        clip.curveTo(0.0f, 0.0f, 0.0f, 0.0f, bevelSize, 0.0f);
        clip.lineTo(w - bevelSize, 0.0f);
        clip.curveTo(w, 0.0f, w, 0.0f, w, bevelSize);
        clip.lineTo(w, h);
        Color fillColor = UIManager.getColor("InternalFrame.activeTitleGradient");
        if (null == fillColor) {
            fillColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        }
        Object rhAA = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint painter = new GradientPaint(0.0f, h / 2, new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 128), 0.0f, h, new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 0));
        g2.setPaint(painter);
        g2.fill(clip);
        Color lineColor = this.getBackground().darker();
        painter = new GradientPaint(0.0f, h / 2, lineColor, 0.0f, h, new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), 0));
        g2.setPaint(painter);
        g2.draw(clip);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rhAA);
        super.paintComponent(g);
    }
}

