/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.util;

import com.levigo.util.swing.IconManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.util.SectionTitleBar;

public class SelectableSectionTitleBar
extends SectionTitleBar {
    protected JButton toggleVisibility;
    protected Icon contentVisible;
    protected Icon contentInVisible;
    protected boolean visible = false;
    protected static final String DEFAULT_ICON_CONTENT_VISIBLE = "list.hide";
    protected static final String DEFAULT_ICON_CONTENT_INVISIBLE = "list.unhide";

    public SelectableSectionTitleBar() {
        this("");
    }

    public SelectableSectionTitleBar(String title) {
        this(title, null, null);
    }

    public SelectableSectionTitleBar(String title, Icon contentVisible, Icon contentInvisible) {
        this.contentVisible = contentVisible != null ? contentVisible : IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon(DEFAULT_ICON_CONTENT_VISIBLE);
        this.contentInVisible = contentInvisible != null ? contentInvisible : IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon(DEFAULT_ICON_CONTENT_INVISIBLE);
        this.toggleVisibility = new JButton();
        this.toggleVisibility.setIcon(this.contentInVisible);
        this.toggleVisibility.setBorder(null);
        this.toggleVisibility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectableSectionTitleBar.this.firePropertyChange("contentVisibility", SelectableSectionTitleBar.this.visible, !SelectableSectionTitleBar.this.visible);
                SelectableSectionTitleBar.this.visible = !SelectableSectionTitleBar.this.visible;
                SelectableSectionTitleBar.this.updateButton();
            }
        });
        this.add(this.toggleVisibility);
        this.add(Box.createGlue());
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(UIManager.getFont("TitledBorder.font"));
        this.add(this.titleLabel);
        this.add(Box.createGlue());
        this.updateUI();
    }

    private void updateButton() {
        if (this.visible) {
            this.toggleVisibility.setIcon(this.contentVisible);
        } else {
            this.toggleVisibility.setIcon(this.contentInVisible);
        }
    }

    public void setContentVisible(boolean visible) {
        this.visible = visible;
        this.updateButton();
    }
}

