/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.util.prefs.BackingStoreException;
import javax.security.auth.callback.CallbackHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.RealmManager;
import org.openthinclient.console.util.UsernamePasswordCallbackHandler;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class DisconnectEnvironmentAction
extends NodeAction {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return true;
    }

    protected void performAction(Node[] nodes) {
        boolean delete = false;
        boolean ask = false;
        if (nodes.length > 1) {
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.DisconnectEnvironmentAction.question2", nodes.length), 0)) == NotifyDescriptor.YES_OPTION) {
                delete = true;
            }
            ask = true;
        }
        for (Node node : nodes) {
            if (!(node instanceof EditorProvider)) continue;
            Realm realm = (Realm)node.getLookup().lookup(Realm.class);
            LDAPConnectionDescriptor lcd = realm.getConnectionDescriptor();
            if (!ask && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("action.DisconnectEnvironmentAction.question1", "\"" + node.getName() + "\""), 0)) == NotifyDescriptor.YES_OPTION) {
                delete = true;
            }
            if (!delete) continue;
            String realmName = lcd.getHostname() + lcd.getBaseDN();
            CallbackHandler handler = lcd.getCallbackHandler();
            UsernamePasswordCallbackHandler call = (UsernamePasswordCallbackHandler)((Object)handler);
            try {
                RealmManager.deregisterRealm(realmName);
                call.deleteCredentials();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    protected boolean enable(Node[] arg0) {
        return true;
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

