/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.viewer.AbstractConnectionWorkerFactory;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.mvp.Model;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class VNCController
extends Viewer
implements WindowListener {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private int paramsMask;
    private boolean allowAppletInteractiveConnections;
    private final ConnectionParams connectionParams = new ConnectionParams();
    private String passwordFromParams;
    boolean isSeparateFrame = true;
    boolean isApplet = true;
    private final ProtocolSettings settings = ProtocolSettings.getDefaultSettings();
    private final UiSettings uiSettings = new UiSettings();
    private volatile boolean isAppletStopped = false;
    private ConnectionPresenter connectionPresenter;

    public static void openConnection(String[] args) {
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions((Parser)parser);
        parser.parse(args);
        VNCController viewer = new VNCController(parser);
        SwingUtilities.invokeLater((Runnable)((Object)viewer));
    }

    public VNCController() {
    }

    private VNCController(Parser parser) {
        this();
        this.setLoggingLevel(parser.isSet("v") ? Level.FINE : (parser.isSet("vv") ? Level.FINER : Level.INFO));
        this.paramsMask = ParametersHandler.completeSettingsFromCLI((Parser)parser, (ConnectionParams)this.connectionParams, (ProtocolSettings)this.settings, (UiSettings)this.uiSettings);
        this.passwordFromParams = parser.getValueFor("password");
        this.logger.info("TightVNC Viewer version " + VNCController.ver());
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        appLogger.setLevel(levelToSet);
        Handler ch = null;
        for (Handler h : appLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = (ConsoleHandler)h;
            break;
        }
        if (null == ch) {
            ch = new ConsoleHandler();
            appLogger.addHandler(ch);
        }
        ch.setLevel(levelToSet);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Window w;
        if (e != null && e.getComponent() != null && (w = e.getWindow()) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.closeApp();
    }

    public void closeApp() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            this.logger.info("Connections cancelled.");
        }
        if (this.isApplet && !this.isAppletStopped) {
            this.logger.severe("Applet is stopped.");
            this.isAppletStopped = true;
            this.repaint();
            this.stop();
        }
    }

    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    public void destroy() {
        this.closeApp();
    }

    public void init() {
        this.paramsMask = ParametersHandler.completeSettingsFromApplet((JApplet)((Object)this), (ConnectionParams)this.connectionParams, (ProtocolSettings)this.settings, (UiSettings)this.uiSettings);
        this.isSeparateFrame = ParametersHandler.isSeparateFrame;
        this.passwordFromParams = this.getParameter("password");
        this.isApplet = true;
        this.allowAppletInteractiveConnections = ParametersHandler.allowAppletInteractiveConnections;
        this.repaint();
        try {
            SwingUtilities.invokeAndWait((Runnable)((Object)this));
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }

    private boolean checkJsch() {
        try {
            Class.forName("com.jcraft.jsch.JSch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void run() {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        this.connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        this.connectionPresenter.addModel("ConnectionParamsModel", (Model)this.connectionParams);
        ConnectionView connectionView = new ConnectionView((WindowListener)this, this.connectionPresenter, hasJsch);
        this.connectionPresenter.addView("ConnectionView", (View)connectionView);
        if (this.isApplet) {
            this.connectionPresenter.addView("AppletStatusStringView", new View(){

                public void showView() {
                }

                public void closeView() {
                }

                public void setMessage(String message) {
                    VNCController.this.getAppletContext().showStatus(message);
                }
            });
        }
        SwingViewerWindowFactory viewerWindowFactory = new SwingViewerWindowFactory(this.isSeparateFrame, true, (Viewer)this);
        this.connectionPresenter.setConnectionWorkerFactory((AbstractConnectionWorkerFactory)new SwingConnectionWorkerFactory(connectionView.getFrame(), this.passwordFromParams, this.connectionPresenter, viewerWindowFactory));
        this.connectionPresenter.startConnection(this.settings, this.uiSettings, this.paramsMask);
    }
}

