/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.levigo.util.swing.IconManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Group;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.User;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ValidateNames;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.nodes.views.ClientEditor;
import org.openthinclient.console.nodes.views.ProfileEditor;
import org.openthinclient.console.nodes.views.RealmEditor;
import org.openthinclient.console.nodes.views.UnrecognizedClientEditor;
import org.openthinclient.console.nodes.views.UserEditor;
import org.openthinclient.console.ui.AssociationEditor;
import org.openthinclient.console.util.ChildValidator;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.ldap.TypeMapping;

public class DirObjectEditor
extends AbstractDetailView
implements Validator {
    public static final String KEY_VALIDATOR = "validator";
    private DirectoryObject dirObject;
    private Realm realm;
    private PresentationModel model;
    private ArrayList<String> existingNames;
    private String oldName;

    private DirContext getContext(Realm realm) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", realm.getConnectionDescriptor().getLDAPUrl());
        return new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate() {
        Class<?> dirObjectClass;
        this.model.triggerCommit();
        if (this.oldName == null) {
            this.oldName = this.dirObject.getName();
        }
        PropertyValidationSupport support = new PropertyValidationSupport((Object)this.dirObject, this.dirObject.getClass().getSimpleName());
        ValidateNames validate = new ValidateNames();
        String name = this.dirObject.getName();
        String result = validate.validate(name, dirObjectClass = this.dirObject.getClass());
        if (result != null) {
            support.addError("name", result);
        }
        if (this.existingNames == null) {
            this.existingNames = new ArrayList();
            try (DirContext ctx = this.getContext(this.realm);){
                String ouName = ((TypeMapping)this.realm.getDirectory().getMapping().getTypes().get(dirObjectClass)).getBaseRDN();
                if (ouName != null) {
                    BasicAttributes att = new BasicAttributes(true);
                    att.put(new BasicAttribute("cn"));
                    NamingEnumeration<SearchResult> ne = ctx.search(ouName, (Attributes)att);
                    while (ne.hasMoreElements()) {
                        SearchResult sr = ne.next();
                        Attributes srName = sr.getAttributes();
                        this.existingNames.add(srName.get("cn").get().toString());
                    }
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (this.existingNames.contains(name) && !name.equals(this.oldName)) {
            support.addError("name", Messages.getString("DirObjectEditor.name.exists"));
        }
        return support.getResult();
    }

    @Override
    public JComponent getHeaderComponent() {
        boolean isMutabel = true;
        boolean isRealm = false;
        String name = this.dirObject.getClass().getSimpleName();
        if (!LDAPDirectory.isMutable(this.dirObject.getClass())) {
            isMutabel = false;
        }
        if (name.equals("Realm")) {
            isRealm = true;
        }
        JPanel panel = new JPanel();
        PresentationModel model = new PresentationModel((ValueModel)new ValueHolder((Object)this.dirObject, true));
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"), Messages.getBundle(), panel);
        dfb.setLeadingColumnOffset(2);
        dfb.setColumn(3);
        if (!isMutabel) {
            dfb.appendI15d("DirObjectEditor.name", BasicComponentFactory.createLabel((ValueModel)model.getModel("name")));
            dfb.appendI15d("DirObjectEditor.description", BasicComponentFactory.createLabel((ValueModel)model.getModel("description")));
        } else if (isRealm) {
            String dn = this.realm.getConnectionDescriptor().getBaseDN();
            dn = dn.replace("\\,", "#%COMMA%#");
            String[] s = dn.split(",");
            String nameRealm = "";
            if (s.length > 0) {
                nameRealm = s[0].replace("ou=", "").trim();
                nameRealm = nameRealm.replace("#%COMMA%#", "\\,").trim();
            }
            JTextField field = new JTextField();
            field.setText(nameRealm);
            dfb.appendI15d("DirObjectEditor.name", field);
            dfb.appendI15d("DirObjectEditor.description", BasicComponentFactory.createTextField((ValueModel)model.getModel("description"), (boolean)true));
        } else {
            dfb.appendI15d("DirObjectEditor.name", BasicComponentFactory.createTextField((ValueModel)model.getModel("name"), (boolean)false));
            dfb.appendI15d("DirObjectEditor.description", BasicComponentFactory.createTextField((ValueModel)model.getModel("description"), (boolean)true));
        }
        panel.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree." + this.dirObject.getClass().getSimpleName())), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
        panel.putClientProperty(KEY_VALIDATOR, this);
        return panel;
    }

    @Override
    public JComponent getMainComponent() {
        return DirObjectEditor.getEditorForDirObject(this.dirObject, this.realm);
    }

    @Override
    public void init(Node[] selection, TopComponent tc) {
        this.realm = null;
        this.dirObject = null;
        for (Node node : selection) {
            if (node instanceof DirObjectNode) {
                this.realm = (Realm)node.getLookup().lookup(Realm.class);
                this.dirObject = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
                continue;
            }
            if (!(node instanceof RealmNode)) continue;
            this.realm = (Realm)node.getLookup().lookup(Realm.class);
            this.dirObject = this.realm;
        }
        if (null == this.dirObject) {
            throw new IllegalStateException("Could not lookup a DirectoryObject instance");
        }
        if (null == this.realm) {
            throw new IllegalStateException("Could not lookup a Realm instance");
        }
        this.model = new PresentationModel((ValueModel)new ValueHolder((Object)this.dirObject, true));
    }

    public static JComponent getEditorForDirObject(DirectoryObject dirObject, Realm realm) {
        Map subgroups;
        JTabbedPane tabbedPane = new JTabbedPane();
        ChildValidator validator = new ChildValidator();
        tabbedPane.putClientProperty(KEY_VALIDATOR, validator);
        if (dirObject instanceof User) {
            DirObjectEditor.addSubView(tabbedPane, new UserEditor((User)dirObject, realm), validator);
        }
        if (dirObject instanceof Client) {
            DirObjectEditor.addSubView(tabbedPane, new ClientEditor((Client)dirObject, realm), validator);
        }
        if (dirObject instanceof UnrecognizedClient) {
            DirObjectEditor.addSubView(tabbedPane, new UnrecognizedClientEditor((UnrecognizedClient)dirObject, realm), validator);
        }
        if (dirObject instanceof Profile) {
            DirObjectEditor.addSubView(tabbedPane, new ProfileEditor((Profile)dirObject, realm), validator);
        }
        if (dirObject instanceof Realm) {
            DirObjectEditor.addSubView(tabbedPane, new RealmEditor(realm), validator);
            Set users = realm.getAdministrators().getMembers();
            AssociationEditor associationEditor = new AssociationEditor(users, realm, User.class, (DirectoryObject)realm.getAdministrators(), 1);
            associationEditor.setName(Messages.getString("DirObjectDetailView.administrators"));
            DirObjectEditor.addSubView(tabbedPane, associationEditor, validator);
        }
        if (dirObject instanceof AssociatedObjectsProvider && (subgroups = ((AssociatedObjectsProvider)dirObject).getAssociatedObjects()) != null) {
            Set keys = subgroups.keySet();
            for (Class memberClass : keys) {
                DirObjectEditor.addSubView(tabbedPane, new AssociationEditor((Set)subgroups.get(memberClass), realm, memberClass, dirObject, 2), validator);
            }
        }
        if (dirObject instanceof Group) {
            Set members = ((Group)dirObject).getMembers();
            HashMap referrers = new HashMap();
            if (members != null && members.size() != 0) {
                for (DirectoryObject member : members) {
                    Set<DirectoryObject> set;
                    if (member.getClass().equals(dirObject.getClass())) continue;
                    if (referrers.containsKey(member.getClass())) {
                        set = (Set)referrers.get(member.getClass());
                        set.add(member);
                        continue;
                    }
                    set = new HashSet<DirectoryObject>();
                    set.add(member);
                    referrers.put(member.getClass(), set);
                }
            }
            Class[] memberClasses = ((Group)dirObject).getMemberClasses();
            for (int i = 0; i < memberClasses.length; ++i) {
                if (referrers.containsKey(memberClasses[i]) || dirObject.getClass().equals(memberClasses[i])) continue;
                referrers.put(memberClasses[i], new HashSet());
            }
            Set keys = referrers.keySet();
            for (Class key : keys) {
                DirObjectEditor.addSubView(tabbedPane, new AssociationEditor((Set)referrers.get(key), realm, key, dirObject, 1), validator);
            }
        }
        return tabbedPane;
    }

    private static void addSubView(JTabbedPane tabbedPane, JComponent subView, ChildValidator validator) {
        JScrollPane scrollPane = new JScrollPane(subView);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("control"), 3), BorderFactory.createLineBorder(UIManager.getColor("controlShadow"))));
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
        tabbedPane.addTab(subView.getName(), scrollPane);
        subView.setVisible(true);
        validator.addValidatorFrom(subView);
    }
}

