/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Group;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.AssociatedObjectsProviderNode;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.DirObjectSetNode;
import org.openthinclient.console.nodes.views.IncomingAssociationsView;
import org.openthinclient.console.nodes.views.NBNodeTreeCellRenderer;
import org.openthinclient.console.nodes.views.NBNodeTreeTableModel;

public class OutgoingAssociationsView
extends JXPanel {
    public OutgoingAssociationsView(AssociatedObjectsProvider aop) {
        this.setLayout(new BorderLayout());
        JXTreeTable tt = new JXTreeTable((TreeTableModel)new MyNBNodeTreeTableModel((Node)new AssociatedObjectsProviderNode(aop)));
        tt.setShowHorizontalLines(false);
        tt.setShowVerticalLines(false);
        tt.setTreeCellRenderer((TreeCellRenderer)new NBNodeTreeCellRenderer());
        tt.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.genericGrey}));
        this.expandOneLevel(tt);
        this.add(tt.getTableHeader(), "North");
        this.add((Component)tt, "Center");
        this.setBorder(Borders.createEmptyBorder((ConstantSize)LayoutStyle.getCurrent().getRelatedComponentsPadY(), (ConstantSize)Sizes.ZERO, (ConstantSize)LayoutStyle.getCurrent().getRelatedComponentsPadY(), (ConstantSize)Sizes.ZERO));
        this.setOpaque(false);
        this.setName(Messages.getString("OutgoingAssociationsView.assigned"));
    }

    private void expandOneLevel(JXTreeTable tt) {
        TreeTableModel model = tt.getTreeTableModel();
        int childCount = model.getChildCount(model.getRoot());
        TreePath rootPath = new TreePath(model.getRoot());
        for (int i = 0; i < childCount; ++i) {
            tt.expandPath(rootPath.pathByAddingChild(model.getChild(model.getRoot(), i)));
        }
    }

    private static class GroupNode
    extends AbstractNode {
        private Class[] memberClasses;
        private static final Logger logger = Logger.getLogger(IncomingAssociationsView.class);

        public GroupNode(Group group) {
            super((Children)new Children.Array());
            this.memberClasses = group.getMemberClasses();
            Set allMembers = group.getMembers();
            for (Class memberClass : this.memberClasses) {
                HashSet<DirectoryObject> members = new HashSet<DirectoryObject>();
                for (DirectoryObject o : allMembers) {
                    if (!memberClass.isAssignableFrom(o.getClass())) continue;
                    members.add(o);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(memberClass + " -> " + members.size()));
                }
                this.getChildren().add(new Node[]{new DirObjectSetNode(memberClass, members)});
            }
        }
    }

    private static class MyNBNodeTreeTableModel
    extends NBNodeTreeTableModel {
        public MyNBNodeTreeTableModel(Node node) {
            super(node);
        }

        @Override
        public Object getValueAt(Object node, int index) {
            switch (index) {
                case 1: {
                    if (!(node instanceof DirObjectNode)) break;
                    return ((DirectoryObject)((DirObjectNode)node).getLookup().lookup(DirectoryObject.class)).getDescription();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return Messages.getString("OutgoingAssociationsView.typeName");
                }
                case 1: {
                    return Messages.getString("OutgoingAssociationsView.description");
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public boolean isLeaf(Object arg0) {
            return arg0 instanceof DirObjectNode;
        }
    }
}

