/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.ErrorManager;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.GroupNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.PasswordNode;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.SectionNode;
import org.openthinclient.common.model.schema.ValueNode;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.SectionPanel;
import org.openthinclient.console.ui.fields.ChoiceField;
import org.openthinclient.console.ui.fields.EntryField;
import org.openthinclient.console.ui.fields.PasswordField;
import org.openthinclient.console.util.DetailViewFormBuilder;

public class ProfileEditor
extends JPanel {
    private static final Logger logger = Logger.getLogger(ProfileEditor.class);

    public ProfileEditor(Profile profile, Realm realm) {
        if (profile != null) {
            try {
                Schema schema = profile.getSchema(realm);
                Node invisibleNode = null;
                if (profile.getClass() == Realm.class) {
                    invisibleNode = schema.getChild("invisibleObjects");
                    schema.removeChild(invisibleNode);
                }
                if (schema != null) {
                    this.layoutConfigPanel(this, profile, (Node)schema, 0, null);
                }
                if (invisibleNode != null) {
                    schema.addChild(invisibleNode);
                }
            }
            catch (SchemaLoadingException e) {
                ErrorManager.getDefault().annotate((Throwable)e, 4096, Messages.getString("ProfileEditor.couldntLoadSchema"), null, null, null);
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.setName(Messages.getString("Profile_title"));
    }

    private void layoutValue(Profile profile, Node node, DetailViewFormBuilder builder) {
        String label;
        String warning = profile.getWarning(node.getKey());
        if (warning != null) {
            JLabel warnLabel = new JLabel(Messages.getString(warning));
            warnLabel.setForeground(Color.RED);
            builder.append((Component)warnLabel, builder.getColumnCount() - builder.getLeadingColumnOffset());
            builder.nextLine();
        }
        if (null == (label = node.getLabel())) {
            label = "";
        }
        if (node instanceof ChoiceNode) {
            builder.append(label, (Component)new ChoiceField(profile, (ChoiceNode)node).getEditor());
        } else if (node instanceof PasswordNode) {
            builder.append(label, (Component)new PasswordField(profile, (PasswordNode)node).getEditor());
        } else if (node instanceof EntryNode) {
            builder.append(label, (Component)new EntryField(profile, (EntryNode)node).getEditor());
        } else if (!(node instanceof ValueNode)) {
            logger.warn((Object)Messages.getString("ProfileEditor.unknownType", node.getClass()));
        }
    }

    private void layoutConfigPanel(JPanel panel, Profile profile, Node node, int indent, String title) {
        DetailViewFormBuilder builder = new DetailViewFormBuilder(new FormLayout(indent + "dlu, left:default, 6dlu, fill:default:grow", ""), Messages.getBundle(), panel);
        builder.setLeadingColumnOffset(1);
        builder.nextColumn();
        if (null != title) {
            builder.appendTitle(title);
            builder.nextLine();
        }
        this.layoutNode(profile, node, builder);
    }

    private void layoutNode(Profile profile, Node node, DetailViewFormBuilder builder) {
        for (Node child : node.getChildren()) {
            if (child instanceof EntryNode) {
                this.layoutValue(profile, child, builder);
                continue;
            }
            if (child instanceof GroupNode) {
                this.layoutGroup(profile, builder, (GroupNode)child);
                continue;
            }
            if (!(child instanceof SectionNode)) continue;
            this.layoutSection(profile, builder, (SectionNode)child);
        }
    }

    private void layoutGroup(Profile profile, DetailViewFormBuilder builder, GroupNode child) {
        if (child.getParent() instanceof GroupNode) {
            JPanel groupPanel = new JPanel();
            this.layoutConfigPanel(groupPanel, profile, (Node)child, 10, child.getLabel());
            groupPanel.setBorder(null);
            builder.append((Component)groupPanel, builder.getColumnCount() - builder.getLeadingColumnOffset());
        } else if (child.getLabel() == null) {
            builder.appendUnrelatedComponentsGapRow();
            builder.nextRow();
            this.layoutNode(profile, (Node)child, builder);
            builder.appendUnrelatedComponentsGapRow();
            builder.nextRow();
        } else {
            builder.appendSeparator(child.getLabel());
            this.layoutNode(profile, (Node)child, builder);
        }
    }

    private void layoutSection(Profile profile, DetailViewFormBuilder builder, SectionNode section) {
        JPanel sectionContents = new JPanel();
        this.layoutConfigPanel(sectionContents, profile, (Node)section, 0, null);
        builder.append((Component)new SectionPanel(section.getLabel(), sectionContents, section.isCollapsed()), builder.getColumnCount() - builder.getLeadingColumnOffset());
        builder.nextLine();
    }
}

