/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.ldap.LdapContext;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.wizards.ConnectionSettingsVisualPanel;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class ConnectionSettingsWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel {
    ConnectionSettingsVisualPanel component;
    private List<String> partitions;
    private Set<Realm> realms;
    private WizardDescriptor wd;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ConnectionSettingsVisualPanel getComponent() {
        if (this.component == null) {
            this.component = new ConnectionSettingsVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.getComponent().valid(this.wd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.getComponent().readSettings((WizardDescriptor)settings);
    }

    public void storeSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.getComponent().storeSettings(this.wd);
        this.wd.putProperty("partitions", this.partitions);
        this.wd.putProperty("realms", this.realms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        LDAPConnectionDescriptor lcd = this.component.createLDAPConnectionDescriptor();
        try {
            DirectoryFacade df = lcd.createDirectoryFacade();
            try (LdapContext ctx = df.createDirContext();){
                ctx.getAttributes("");
                this.wd.putProperty("serverType", (Object)df.guessDirectoryType());
                this.wd.putProperty("schema", (Object)ctx.getSchema(""));
            }
        }
        catch (AuthenticationException e) {
            this.throwValidationException(Messages.getString("ConnectionSettings.error.auth_failed"));
        }
        catch (NameNotFoundException e) {
            this.throwValidationException(Messages.getString("ConnectionSettings.error.name_not_found", lcd.getBaseDN()));
        }
        catch (Throwable e) {
            this.throwValidationException(Messages.getString("ConnectionSettings.error.comm_failed", e.toString()));
        }
    }

    private void throwValidationException(String msg) throws WizardValidationException {
        throw new WizardValidationException((JComponent)this.getComponent(), msg, msg);
    }

    public void prepareValidation() {
        this.component.setEnabled(false);
    }
}

