/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jnlp.ServiceManager;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class JreFix {
    private static String badVersionInfo = null;
    private static AppContext awtEventDispatchContext = null;
    private static AppContext mainThreadContext = null;
    private static Boolean isWebStart = null;

    public static void init() {
        if (JreFix.isWebstart() && JreFix.isApplicableJvmType()) {
            String javaVersion = System.getProperty("java.version");
            JvmVersion parsedVersion = JvmVersion.parse(javaVersion);
            if (parsedVersion != null) {
                int major = parsedVersion.getMajor();
                int minor = parsedVersion.getMinor();
                int patch = parsedVersion.getPatch();
                if (major == 7 && minor == 0 && patch >= 25 || major == 6 && minor == 0 && patch >= 51) {
                    badVersionInfo = major + "u" + patch;
                }
            }
            if ("javaws-10.25.2.16".equals(System.getProperty("javawebstart.version"))) {
                badVersionInfo = "Web Start 10.25.2.16";
            }
        }
        if (badVersionInfo != null) {
            System.err.println("You're running a broken JDK/JRE. Trying to apply runtime fix.");
            mainThreadContext = AppContext.getAppContext();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Checking EDT AppContext...");
                        awtEventDispatchContext = AppContext.getAppContext();
                        if (awtEventDispatchContext == null) {
                            System.err.println("JRE/JDK has no AppContext assigned to the EDT. Trying to fix this.");
                            JreFix.fixCurrentThreadAppContext(null);
                        }
                    }
                });
            }
            catch (Exception e) {
                JreFix.displayErrorAndExit(null);
            }
            for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
                if (JreFix.hasAppContext(tg)) continue;
                System.err.println("Detected ThreadGroup without AppContext: " + tg.getName() + ". Assigning a new AppContext");
                JreFix.fixThreadGroupAppContext(null, tg);
            }
            if (mainThreadContext == null || awtEventDispatchContext == null) {
                JreFix.displayErrorAndExit(null);
            }
        }
    }

    private static boolean hasAppContext(ThreadGroup tg) {
        try {
            Field field = AppContext.class.getDeclaredField("threadGroup2appContext");
            field.setAccessible(true);
            Map threadGroup2appContext = (Map)field.get(null);
            return threadGroup2appContext.get(tg) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void invokeNowOrLater(Runnable runnable) {
        if (JreFix.hasAppContextBug()) {
            JreFix.invokeLaterOnAwtEventDispatchThreadContext(runnable);
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeNowOrWait(Runnable runnable) {
        if (JreFix.hasAppContextBug()) {
            JreFix.fixCurrentThreadAppContext(null);
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasAppContextBug() {
        return JreFix.isJreWithAppContextBug() && AppContext.getAppContext() == null;
    }

    public static void invokeLaterOnAwtEventDispatchThreadContext(Runnable runnable) {
        SunToolkit.invokeLaterOnAppContext(awtEventDispatchContext, runnable);
    }

    public static void fixCurrentThreadAppContext(Component parent) {
        JreFix.fixThreadGroupAppContext(parent, Thread.currentThread().getThreadGroup());
        if (AppContext.getAppContext() == null) {
            JreFix.displayErrorAndExit(parent);
        }
    }

    public static void fixThreadGroupAppContext(Component parent, ThreadGroup currentThreadGroup) {
        try {
            Field field = AppContext.class.getDeclaredField("threadGroup2appContext");
            field.setAccessible(true);
            Map threadGroup2appContext = (Map)field.get(null);
            threadGroup2appContext.put(currentThreadGroup, mainThreadContext);
        }
        catch (Exception e) {
            JreFix.displayErrorAndExit(parent);
        }
    }

    private static boolean isJreWithAppContextBug() {
        return badVersionInfo != null;
    }

    private static void displayErrorAndExit(Component parent) {
        JLabel msgLabel = new JLabel("<html>Our application cannot run using <b>Web Start</b> with this version of Java.<p><p>Java " + badVersionInfo + " contains a bug acknowledged by Oracle (JDK-8019274).");
        JOptionPane.showMessageDialog(parent, msgLabel, "Java Version Error", 0);
        System.exit(1);
    }

    private static boolean isApplicableJvmType() {
        String vendor = System.getProperty("java.vendor");
        String vmName = System.getProperty("java.vm.name");
        if (vendor != null && vmName != null) {
            return vmName.contains("Java HotSpot") && (vendor.equals("Oracle Corporation") || vendor.equals("Sun Microsystems Inc."));
        }
        return false;
    }

    private static boolean isWebstart() {
        if (isWebStart == null) {
            try {
                ServiceManager.lookup((String)"javax.jnlp.BasicService");
                isWebStart = true;
            }
            catch (NoClassDefFoundError err) {
                isWebStart = false;
            }
            catch (Exception e) {
                isWebStart = false;
            }
        }
        return isWebStart;
    }

    public static class JvmVersion {
        private final int major;
        private final int minor;
        private final int patch;

        public static JvmVersion parse(String version) {
            if (version == null) {
                return null;
            }
            Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)");
            Matcher m = p.matcher(version);
            if (m.find()) {
                int generation = Integer.valueOf(m.group(1));
                int major = Integer.valueOf(m.group(2));
                int minor = Integer.valueOf(m.group(3));
                int patch = Integer.valueOf(m.group(4));
                if (generation != 1) {
                    return null;
                }
                return new JvmVersion(major, minor, patch);
            }
            return null;
        }

        public JvmVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }
    }
}

