/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.VNCController;

public class OpenVNCConnectionAction
extends NodeAction {
    private static final long serialVersionUID = 1L;
    private static final Pattern IPADDRESS_PATTERN = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
    private static String fileName = "/openthinclient/files/var/log/syslog.log";

    protected boolean asynchronous() {
        return true;
    }

    protected boolean enable(Node[] nodes) {
        return this.getClients(nodes).iterator().hasNext();
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void performAction(Node[] nodes) {
        for (Client client : this.getClients(nodes)) {
            String macAddress = client.getMacAddress();
            String logIpAddress = null;
            String homeServer = "";
            Realm realm = (Realm)nodes[0].getLookup().lookup(Realm.class);
            if (null != realm.getSchemaProviderName()) {
                homeServer = realm.getSchemaProviderName();
            } else if (null != realm.getConnectionDescriptor().getHostname()) {
                homeServer = realm.getConnectionDescriptor().getHostname();
            }
            if (homeServer == null || homeServer.length() == 0) {
                homeServer = "localhost";
            }
            try {
                URL url = new URL("http", homeServer, 8080, fileName);
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(macAddress)) continue;
                    Matcher matcher = IPADDRESS_PATTERN.matcher(line);
                    while (matcher.find()) {
                        logIpAddress = matcher.group();
                    }
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (logIpAddress == null) {
                Component frame = null;
                JOptionPane.showMessageDialog(frame, Messages.getString("OpenVNCConnectionNullPointerException"));
                continue;
            }
            VNCController.openConnection(new String[]{"-port=5900", "-host=", logIpAddress, "-FullScreen=NO"});
        }
    }

    private Iterable<Client> getClients(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Node n : nodes) {
            Client client = this.toClient(n);
            if (client == null) continue;
            clients.add(client);
        }
        return clients;
    }

    private Client toClient(Node node) {
        DirectoryObject client = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
        if (client instanceof Client) {
            return (Client)client;
        }
        return null;
    }
}

