/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.levigo.util.swing.IconManager;
import java.awt.Image;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.ClientLogAction;
import org.openthinclient.console.DeleteNodeAction;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.DuplicateAction;
import org.openthinclient.console.EditAction;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.OpenVNCConnectionAction;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.views.DirObjectDetailView;
import org.openthinclient.console.nodes.views.DirObjectEditor;
import org.openthinclient.ldap.DirectoryException;

public class DirObjectNode
extends MyAbstractNode
implements DetailViewProvider,
EditorProvider,
Refreshable {
    private final Set validDuplicateClassesSet = new HashSet<Class>(Arrays.asList(Application.class, Device.class, HardwareType.class, Location.class, Printer.class));

    public DirObjectNode(Node node, DirectoryObject object) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{object}), node.getLookup()}));
    }

    @Override
    public String getName() {
        return ((DirectoryObject)this.getLookup().lookup(DirectoryObject.class)).getName();
    }

    public Action[] getActions(boolean context) {
        DirectoryObject dirObject = (DirectoryObject)this.getLookup().lookup(DirectoryObject.class);
        Class<?> dirObjectClass = dirObject.getClass();
        if (dirObjectClass.equals(Client.class)) {
            if (this.isWritable()) {
                return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(ClientLogAction.class), SystemAction.get(OpenVNCConnectionAction.class), SystemAction.get(DeleteNodeAction.class)};
            }
            return new Action[]{SystemAction.get(ClientLogAction.class)};
        }
        if (this.isWritable()) {
            if (this.validDuplicateClassesSet.contains(dirObjectClass)) {
                return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(DuplicateAction.class), SystemAction.get(DeleteNodeAction.class)};
            }
            return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(DeleteNodeAction.class)};
        }
        return new Action[0];
    }

    public SystemAction getDefaultAction() {
        if (this.isWritable()) {
            return SystemAction.get(EditAction.class);
        }
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        Class currentClass = (Class)this.getLookup().lookup(Class.class);
        return LDAPDirectory.isMutable((Class)currentClass);
    }

    public void destroy() throws IOException {
        DirectoryObject object = (DirectoryObject)this.getLookup().lookup(DirectoryObject.class);
        Realm realm = (Realm)this.getLookup().lookup(Realm.class);
        if (null == realm || null == object) {
            throw new IllegalStateException("Don't have a directory or object");
        }
        try {
            realm.getDirectory().delete((Object)object);
            super.destroy();
            Node node = this.getParentNode();
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().annotate((Throwable)e, 4096, Messages.getString("DirObjectNode.cantDelete"), null, null, null);
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public boolean canRename() {
        return false;
    }

    public void setName(String s) {
        Node[] nodes;
        if (null == s || s.length() == 0) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Messages.getString("DirObjectNode.nameInvalid", s), Messages.getString("DirObjectNode.cantChangeName"), -1, 0, null, null));
            return;
        }
        for (Node node : nodes = this.getParentNode().getChildren().getNodes()) {
            DirObjectNode don;
            DirectoryObject object;
            if (!(node instanceof DirObjectNode) || null == (object = (DirectoryObject)(don = (DirObjectNode)node).getLookup().lookup(DirectoryObject.class)) || !object.getName().equals(s)) continue;
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Messages.getString("DirObjectNode.alreadyExists"), Messages.getString("DirObjectNode.cantChangeName"), -1, 0, null, null));
            return;
        }
        DirectoryObject object = (DirectoryObject)this.getLookup().lookup(DirectoryObject.class);
        Realm realm = (Realm)this.getLookup().lookup(Realm.class);
        if (null == realm || null == object) {
            throw new IllegalStateException("Don't have a directory or object");
        }
        String oldName = object.getName();
        DirectoryObject copy = null;
        try {
            copy = (DirectoryObject)realm.getDirectory().load(object.getClass(), object.getDn(), true);
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        if (object instanceof Realm) {
            ((Realm)copy).setConnectionDescriptor(((Realm)object).getConnectionDescriptor());
        }
        copy.setName(s);
        try {
            realm.getDirectory().save((Object)copy);
            Node parentNode = this.getParentNode();
            if (null != parentNode && parentNode instanceof Refreshable) {
                ((Refreshable)parentNode).refresh();
            }
        }
        catch (DirectoryException e) {
            e.printStackTrace();
            object.setName(oldName);
            ErrorManager.getDefault().annotate((Throwable)e, 65536, null, Messages.getString("DirObjectNode.cantSave"), null, null);
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    @Override
    public Image getIcon(int type) {
        DirectoryObject o = (DirectoryObject)this.getLookup().lookup(DirectoryObject.class);
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + o.getClass().getSimpleName());
    }

    @Override
    public DetailView getDetailView() {
        return new DirObjectDetailView();
    }

    @Override
    public DetailView getEditor() {
        return new DirObjectEditor();
    }

    @Override
    public void refresh() {
        Realm realm = (Realm)this.getLookup().lookup(Realm.class);
        DirectoryObject o = (DirectoryObject)this.getLookup().lookup(DirectoryObject.class);
        try {
            realm.getDirectory().refresh((Object)o);
            this.fireCookieChange();
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

