/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.PasswordNode;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.ErrorPanel;

public class ProfileView
extends JXPanel {
    public ProfileView(Profile profile, Realm realm) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        try {
            Schema schema = profile.getSchema(realm);
            Node invisibleNote = null;
            if (profile.getClass() == Realm.class) {
                invisibleNote = schema.getChild("invisibleObjects");
                schema.removeChild(invisibleNote);
            }
            if (schema != null) {
                JXTreeTable tt = new JXTreeTable((TreeTableModel)new ProfileTreeTableModel((Node)schema, profile));
                tt.setShowHorizontalLines(false);
                tt.setShowVerticalLines(false);
                tt.expandAll();
                tt.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer());
                tt.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.genericGrey}));
                this.add(tt.getTableHeader(), "North");
                this.add((Component)tt, "Center");
                this.setBorder(Borders.createEmptyBorder((ConstantSize)LayoutStyle.getCurrent().getRelatedComponentsPadY(), (ConstantSize)Sizes.ZERO, (ConstantSize)LayoutStyle.getCurrent().getRelatedComponentsPadY(), (ConstantSize)Sizes.ZERO));
                if (invisibleNote != null) {
                    schema.addChild(invisibleNote);
                }
            }
        }
        catch (SchemaLoadingException e) {
            e.printStackTrace();
            this.add(new ErrorPanel(Messages.getString("ProfileViewFactory.errors.couldNotLoadSchema"), null, null, e));
        }
        this.setName(Messages.getString("ProfileViewFactory.title"));
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JTree tree;
        private final Rectangle iconRect = new Rectangle();
        private final Rectangle textRect = new Rectangle();
        private final Rectangle itemRect = new Rectangle();

        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.tree = tree;
            if (value instanceof Node) {
                value = ((Node)value).getLabel();
            }
            JLabel r = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            r.setIcon(null);
            return r;
        }

        @Override
        public void paint(Graphics g) {
            String fullText = super.getText();
            String shortText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), fullText, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
            this.setText(shortText);
            super.paint(g);
            this.setText(fullText);
        }

        private Rectangle getItemRect(Rectangle itemRect) {
            this.getBounds(itemRect);
            itemRect.width = this.tree.getWidth() - itemRect.x;
            return itemRect;
        }
    }

    private static class ProfileTreeTableModel
    extends AbstractTreeTableModel {
        private final Profile profile;

        ProfileTreeTableModel(Node root, Profile profile) {
            super((Object)root);
            this.profile = profile;
        }

        public Object getValueAt(Object node, int index) {
            Node n = (Node)node;
            String value = this.profile.getValue(n.getKey());
            switch (index) {
                case 0: {
                    return n.getLabel();
                }
                case 1: {
                    if (node instanceof PasswordNode && null != value) {
                        String hiddenValue = "";
                        for (int i = 0; i < value.length(); ++i) {
                            hiddenValue = hiddenValue + "*";
                        }
                        return hiddenValue;
                    }
                    if (node instanceof ChoiceNode) {
                        ChoiceNode cn = (ChoiceNode)node;
                        return cn.getLabelForValue(value);
                    }
                    return value;
                }
                case 2: {
                    String k = n.getKey();
                    boolean containsValue = this.profile.containsValue(k);
                    String definingProfile = this.profile.getDefiningProfile(k, true);
                    if (containsValue) {
                        String overriddenValue = this.profile.getOverriddenValue(k);
                        if (node instanceof ChoiceNode) {
                            ChoiceNode cn = (ChoiceNode)node;
                            overriddenValue = cn.getLabelForValue(overriddenValue);
                        }
                        if (null == overriddenValue) break;
                        return MessageFormat.format(Messages.getString("ProfileViewFactory.overrides"), overriddenValue, definingProfile);
                    }
                    if (null != value) {
                        return MessageFormat.format(Messages.getString("ProfileViewFactory.defaultFrom"), definingProfile);
                    }
                    return Messages.getString("ProfileViewFactory.noDefault");
                }
            }
            return "";
        }

        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return Messages.getString("ProfileViewFactory.Name");
                }
                case 1: {
                    return Messages.getString("ProfileViewFactory.Value");
                }
                case 2: {
                    return Messages.getString("ProfileViewFactory.Remarks");
                }
            }
            return "?";
        }

        public void setValueAt(Object arg0, Object arg1, int arg2) {
            throw new IllegalArgumentException("not editable");
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getChild(Object parent, int idx) {
            return ((Node)parent).getChildren().get(idx);
        }

        public int getChildCount(Object parent) {
            return ((Node)parent).getChildren().size();
        }
    }
}

