/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.Messages;
import org.openthinclient.ldap.auth.CachingCallbackHandler;

public class UsernamePasswordCallbackHandler
implements CachingCallbackHandler {
    private static final Preferences prefs = ConsoleFrame.PREFERENCES_ROOT.node("credentials");
    private static final Logger logger = Logger.getLogger(UsernamePasswordCallbackHandler.class);
    private String protectionDomain;
    private Key key;
    private String username;
    private SealedObject password;
    private boolean savePassword;

    public UsernamePasswordCallbackHandler(String protectionDomain, String username, char[] password, boolean savePassword) {
        this.protectionDomain = protectionDomain;
        this.savePassword = savePassword;
        try {
            this.key = KeyGenerator.getInstance("DES").generateKey();
            this.username = username;
            this.password = this.scramble((Serializable)password);
            this.saveCredentials(savePassword);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Crypto prerequisites not met", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't scramble credentials", e);
        }
    }

    public UsernamePasswordCallbackHandler(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        try {
            this.key = KeyGenerator.getInstance("DES").generateKey();
            this.username = null;
            this.password = null;
            String sn = this.getStoreName();
            if (prefs.nodeExists(sn)) {
                Preferences p = prefs.node(sn);
                this.username = p.get("username", "");
                byte[] scrambledPassword = p.getByteArray("password", null);
                if (scrambledPassword != null) {
                    try {
                        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(scrambledPassword));
                        this.password = (SealedObject)ois.readObject();
                        this.key = (Key)ois.readObject();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Can't load saved credentials - will query user");
                    }
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Crypto prerequisites not met", e);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Can't access credentials", e);
        }
    }

    private void saveCredentials(boolean savePassword) throws IOException {
        Preferences p = prefs.node(this.getStoreName());
        p.put("username", this.username);
        if (savePassword) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.password);
                oos.writeObject(this.key);
                oos.flush();
                p.putByteArray("password", baos.toByteArray());
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    private String getStoreName() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(this.protectionDomain.getBytes());
            byte[] bs = digest.digest();
            StringBuffer sb = new StringBuffer(bs.length * 2);
            for (int i = 0; i < bs.length; ++i) {
                String s = Integer.toHexString(bs[i] & 0xFF);
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't save credentials: digest method MD5 unavailable.");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                if (null == this.username) {
                    this.queryForPassword();
                }
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (!(callback instanceof PasswordCallback)) continue;
            if (null == this.password) {
                this.queryForPassword();
            }
            ((PasswordCallback)callback).setPassword((char[])this.unscramble(this.password));
        }
    }

    private void queryForPassword() throws IOException {
        PasswordEntryPanel pep = new PasswordEntryPanel(false);
        DialogDescriptor dd = new DialogDescriptor((Object)pep, Messages.getString("UsernamePassword.titleEnterPassword"), true, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
            throw new IOException("User cancelled password entry");
        }
        this.username = pep.getUsername();
        this.password = this.scramble((Serializable)pep.getPassword());
        this.saveCredentials(pep.getSavePassword());
    }

    public void purgeCache() throws IOException {
        PasswordEntryPanel pep = new PasswordEntryPanel(true);
        DialogDescriptor dd = new DialogDescriptor((Object)pep, Messages.getString("UsernamePassword.titleLoginFailed"), true, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
            throw new IOException("User cancelled password entry");
        }
        this.username = pep.getUsername();
        this.password = this.scramble((Serializable)pep.getPassword());
        this.saveCredentials(pep.getSavePassword());
    }

    private SealedObject scramble(Serializable clear) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(1, this.key);
            return new SealedObject(clear, cipher);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Can't scramble: " + e);
        }
    }

    private Object unscramble(SealedObject scrambled) throws IOException {
        try {
            return scrambled.getObject(this.key);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Can't unscramble: " + e);
        }
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) throws IOException {
        try {
            this.deleteCredentials();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Can't access credentials", e);
        }
        this.protectionDomain = protectionDomain;
        this.saveCredentials(this.savePassword);
    }

    public void deleteCredentials() throws BackingStoreException {
        Preferences p = prefs.node(this.getStoreName());
        p.removeNode();
    }

    private class PasswordEntryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JPasswordField passwordField;
        private final JCheckBox savePasswordBox;
        private final JTextField userField;

        PasswordEntryPanel(boolean askForUsername) throws IOException {
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 3dlu, f:p:g"), Messages.getBundle(), (JPanel)this);
            dfb.setDefaultDialogBorder();
            dfb.append((Component)new JLabel(Messages.getString("UsernamePassword.subtitle")), 3);
            dfb.nextLine();
            JLabel pd = new JLabel(UsernamePasswordCallbackHandler.this.protectionDomain);
            dfb.append("", (Component)pd);
            dfb.nextLine();
            dfb.appendUnrelatedComponentsGapRow();
            dfb.nextLine();
            this.userField = new JTextField(UsernamePasswordCallbackHandler.this.username);
            this.userField.setEnabled(true);
            dfb.appendI15d("UsernamePassword.username", (Component)this.userField);
            dfb.nextLine();
            this.passwordField = new JPasswordField();
            dfb.appendI15d("UsernamePassword.password", (Component)this.passwordField);
            dfb.nextLine();
            this.savePasswordBox = new JCheckBox(Messages.getString("UsernamePassword.savePassword"));
            dfb.append((Component)this.savePasswordBox, 3);
        }

        char[] getPassword() {
            return this.passwordField.getPassword();
        }

        boolean getSavePassword() {
            return this.savePasswordBox.isSelected();
        }

        String getUsername() {
            return this.userField.getText();
        }
    }
}

