/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.newdirobject;

import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.message.PropertyValidationMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.views.DirObjectEditor;
import org.openthinclient.console.util.ChildValidator;

public class ConfigurationPanel
implements WizardDescriptor.Panel {
    private WizardDescriptor wd;
    private DirectoryObject newDirectoryObject;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private final ChildValidator validator = new ChildValidator();
    private final JPanel component = new JPanel(new BorderLayout());

    public Component getComponent() {
        this.component.setName(this.getName());
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Messages.getString("ConfigurationPanel.name");
    }

    public boolean isValid() {
        ValidationResult validate = this.validator.validate();
        if (!validate.hasErrors()) {
            if (validate.hasMessages()) {
                PropertyValidationMessage m = (PropertyValidationMessage)validate.getMessages().get(0);
                this.wd.putProperty("WizardPanel_errorMessage", (Object)m.formattedText());
            } else {
                this.wd.putProperty("WizardPanel_errorMessage", null);
            }
            return true;
        }
        PropertyValidationMessage m = (PropertyValidationMessage)validate.getErrors().iterator().next();
        this.wd.putProperty("WizardPanel_errorMessage", (Object)m.formattedText());
        return false;
    }

    public void readSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        Realm realm = (Realm)this.wd.getProperty("realm");
        Class type = (Class)this.wd.getProperty("type");
        try {
            this.newDirectoryObject = (DirectoryObject)type.newInstance();
            this.newDirectoryObject.setName(this.wd.getProperty("name").toString());
            this.newDirectoryObject.setDescription(this.wd.getProperty("description").toString());
            if (this.newDirectoryObject instanceof Profile) {
                String schemaType = this.wd.getProperty("schemaType").toString();
                ((Profile)this.newDirectoryObject).setSchema(realm.getSchemaProvider().getSchema(this.newDirectoryObject.getClass(), schemaType));
            }
            this.newDirectoryObject.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConfigurationPanel.this.fireChangeEvent();
                }
            });
            JComponent component = DirObjectEditor.getEditorForDirObject(this.newDirectoryObject, realm);
            this.setConfigPanel(component);
            this.validator.addValidatorFrom(component);
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, 4096, Messages.getString("NewDirObject.schema_not_loaded_error"), null, null, null);
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void setConfigPanel(JComponent panel) {
        this.component.removeAll();
        this.component.add((Component)panel, "Center");
        this.component.revalidate();
        this.component.repaint();
    }

    public void storeSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.wd.putProperty("dirObject", (Object)this.newDirectoryObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }
}

