/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.registerrealm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.wizards.registerrealm.SearchRealmDirectoryNode;
import org.openthinclient.console.wizards.registerrealm.SearchRealmDirectoryViewNode;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class ChooseRealmWizardPanel
extends JPanel
implements ExplorerManager.Provider,
WizardDescriptor.Panel {
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private final ExplorerManager manager = new ExplorerManager();
    private LDAPConnectionDescriptor connectionDescriptor;

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public boolean isValid() {
        if (null == this.manager) {
            return false;
        }
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof RealmNode)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        this.connectionDescriptor = (LDAPConnectionDescriptor)wd.getProperty("connectionDescriptor");
        DetailViewProvider root = !this.connectionDescriptor.isBaseDnSet() ? new SearchRealmDirectoryNode(this.connectionDescriptor) : new SearchRealmDirectoryViewNode(this.connectionDescriptor);
        this.manager.setRootContext((Node)root);
    }

    public void storeSettings(Object settings) {
        Realm realm = null;
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof RealmNode)) continue;
            realm = (Realm)((RealmNode)node).getLookup().lookup(Realm.class);
        }
        ((WizardDescriptor)settings).putProperty("realm", realm);
    }

    public ChooseRealmWizardPanel() {
        BeanTreeView view = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)view, "Center");
        view.setDefaultActionAllowed(false);
        view.setRootVisible(true);
        view.setPopupAllowed(false);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChooseRealmWizardPanel.this.fireChangeEvent();
            }
        });
    }

    @Override
    public String getName() {
        return Messages.getString("RegisterRealm2_name");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

