/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.importer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.openthinclient.api.importer.model.ProfileReference;
import org.openthinclient.api.importer.model.ProfileType;
import org.openthinclient.api.rest.model.AbstractProfileObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImportableClient
extends AbstractProfileObject {
    @JsonProperty
    private Set<ProfileReference> applications;
    @JsonProperty
    private Set<ProfileReference> printers;
    @JsonProperty
    private Set<ProfileReference> devices;
    @JsonProperty(required=true)
    private ProfileReference hardwareType;
    @JsonProperty
    private ProfileReference location;
    @JsonProperty(value="macAddress")
    @NotNull
    private String macAddress;

    public ImportableClient() {
        super(ProfileType.CLIENT);
    }

    public Set<ProfileReference> getApplications() {
        if (this.applications == null) {
            this.applications = new HashSet<ProfileReference>();
        }
        return this.applications;
    }

    public Set<ProfileReference> getPrinters() {
        if (this.printers == null) {
            this.printers = new HashSet<ProfileReference>();
        }
        return this.printers;
    }

    public Set<ProfileReference> getDevices() {
        if (this.devices == null) {
            this.devices = new HashSet<ProfileReference>();
        }
        return this.devices;
    }

    public ProfileReference getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(ProfileReference hardwareType) {
        this.hardwareType = hardwareType;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public ProfileReference getLocation() {
        return this.location;
    }

    public void setLocation(ProfileReference location) {
        this.location = location;
    }
}

