/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.event.selection.SelectionEvent;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.StyleGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.SingleSelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.sidebar.OTCSideBarUtils;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.exception.AllItemsListException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.components.AbstractSideBar;
import org.vaadin.spring.sidebar.components.ValoSideBar;

public class OTCSideBar
extends ValoSideBar
implements ViewChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OTCSideBar.class);
    public static final String SIDE_BAR_STYLE = "sideBar";
    public static final String SIDE_BAR_SECTION_ITEM_STYLE = "sideBarSectionItem";
    public static final String SIDE_BAR_SECTION_STYLE = "sideBarSection";
    public static final String SELECTED_STYLE = "selected";
    private OTCSideBarUtils sideBarUtils;
    private Map<SideBarItemDescriptor, FilterGrid> itemsMap = new HashMap<SideBarItemDescriptor, FilterGrid>();
    private final String sectionId;

    public OTCSideBar(String sectionId, OTCSideBarUtils sideBarUtils) {
        super((SideBarUtils)sideBarUtils);
        this.sideBarUtils = sideBarUtils;
        this.sectionId = sectionId;
    }

    protected AbstractSideBar.SectionComponentFactory<CssLayout> createDefaultSectionComponentFactory() {
        return new DefaultSectionComponentFactory();
    }

    protected AbstractSideBar.ItemComponentFactory createDefaultItemComponentFactory() {
        return new DefaultItemComponentFactory();
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        return true;
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        String state = event.getNavigator().getState();
        String viewName = event.getViewName();
        Map parameterMap = event.getParameterMap();
        LOGGER.debug("Current view {} {}", (Object)state, (Object)parameterMap);
        if (state != null && parameterMap.size() == 1) {
            String directoryObjectName = (String)parameterMap.keySet().iterator().next();
            Optional<SideBarItemDescriptor> descriptor = this.itemsMap.keySet().stream().filter(sideBarItemDescriptor -> sideBarItemDescriptor.getItemId().endsWith(viewName.replaceAll("_", "").toLowerCase())).findFirst();
            if (descriptor.isPresent()) {
                FilterGrid filterGrid = this.itemsMap.get(descriptor.get());
                if (filterGrid.getSize() == 0) {
                    filterGrid.setItems(this.getAllItems(descriptor.get()));
                }
                filterGrid.markSelectedItem(directoryObjectName);
                filterGrid.setVisible(true);
                this.itemsMap.values().stream().filter(gridComponent -> !gridComponent.equals((Object)filterGrid)).forEach(gridComponent -> gridComponent.setVisible(false));
            }
        } else {
            this.itemsMap.values().forEach(gridComponent -> gridComponent.setVisible(false));
        }
    }

    public void selectItem(String viewName, DirectoryObject directoryObject, Set<DirectoryObject> directoryObjectSet) {
        Optional<SideBarItemDescriptor> descriptor = this.itemsMap.keySet().stream().filter(sideBarItemDescriptor -> sideBarItemDescriptor.getItemId().endsWith(viewName.replaceAll("_", "").toLowerCase())).findFirst();
        if (descriptor.isPresent()) {
            FilterGrid filterGrid = this.itemsMap.get(descriptor.get());
            filterGrid.setItems(directoryObjectSet);
            filterGrid.setVisible(true);
            if (directoryObject != null) {
                filterGrid.markSelectedItem(directoryObject.getName());
            }
        }
    }

    public DirectoryObject getSelectedItem(String viewName) {
        Optional<SideBarItemDescriptor> descriptor = this.itemsMap.keySet().stream().filter(sideBarItemDescriptor -> sideBarItemDescriptor.getItemId().endsWith(viewName.replaceAll("_", "").toLowerCase())).findFirst();
        if (descriptor.isPresent()) {
            FilterGrid grid = this.itemsMap.get(descriptor.get());
            return grid.getSelectedItem();
        }
        return null;
    }

    private void showContent(String viewName, SelectionEvent<DirectoryObject> selectionEvent) {
        Optional selectedItem = selectionEvent.getFirstSelectedItem();
        if (selectionEvent.isUserOriginated()) {
            Navigator navigator = UI.getCurrent().getNavigator();
            if (selectedItem.isPresent()) {
                navigator.navigateTo(viewName + "/" + ((DirectoryObject)selectedItem.get()).getName());
            }
        }
    }

    private Set<DirectoryObject> getAllItems(SideBarItemDescriptor item) {
        Optional<Map.Entry> nameType = this.sideBarUtils.getNameTypeMap().entrySet().stream().filter(entry -> item.getItemId().contains(((String)entry.getKey()).toLowerCase())).findFirst();
        if (nameType.isPresent()) {
            Class sideBarItemClass = (Class)nameType.get().getValue();
            LOGGER.debug("Fetch menu-items for {}", (Object)sideBarItemClass);
            Object bean = this.sideBarUtils.getApplicationContext().getBean(sideBarItemClass);
            if (bean instanceof AbstractThinclientView) {
                try {
                    return ((AbstractThinclientView)((Object)bean)).getAllItems();
                }
                catch (AllItemsListException e) {
                    LOGGER.error("Cannot fetch all items for " + item.getItemId() + ": " + e.getMessage());
                    return new HashSet<DirectoryObject>();
                }
            }
        }
        return new HashSet<DirectoryObject>();
    }

    private void showGridItems(SideBarItemDescriptor descriptor) {
        FilterGrid grid = this.itemsMap.get(descriptor);
        grid.setItems(this.getAllItems(descriptor));
        grid.setVisible(true);
        this.itemsMap.entrySet().stream().filter(e -> !((SideBarItemDescriptor)e.getKey()).equals(descriptor)).forEach(e -> ((FilterGrid)((Object)((Object)e.getValue()))).setVisible(false));
    }

    public void attach() {
        super.attach();
        if (this.getUI().getNavigator() == null) {
            throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
        }
        this.getUI().getNavigator().addViewChangeListener((ViewChangeListener)this);
        CssLayout compositionRoot = this.createCompositionRoot();
        this.setCompositionRoot((Component)compositionRoot);
        for (SideBarSectionDescriptor section : this.sideBarUtils.getSideBarSections(this.getUI().getClass())) {
            if (!section.getId().equals(this.sectionId)) continue;
            this.createSection(compositionRoot, section, this.sideBarUtils.getSideBarItems(section));
        }
    }

    private void createSection(CssLayout compositionRoot, SideBarSectionDescriptor section, Collection<SideBarItemDescriptor> items) {
        if (this.getItemFilter() == null) {
            this.getSectionComponentFactory().createSection((ComponentContainer)compositionRoot, section, items);
        } else {
            ArrayList<SideBarItemDescriptor> passedItems = new ArrayList<SideBarItemDescriptor>();
            for (SideBarItemDescriptor candidate : items) {
                if (!this.getItemFilter().passesFilter(candidate)) continue;
                passedItems.add(candidate);
            }
            if (!passedItems.isEmpty()) {
                this.getSectionComponentFactory().createSection((ComponentContainer)compositionRoot, section, passedItems);
            }
        }
    }

    class ViewItemButton
    extends ItemButton
    implements ViewChangeListener {
        private final String viewName;
        private static final String STYLE_SELECTED = "selected";

        ViewItemButton(SideBarItemDescriptor.ViewItemDescriptor descriptor) {
            super((SideBarItemDescriptor)descriptor);
            this.viewName = descriptor.getViewName();
        }

        public void attach() {
            super.attach();
            if (this.getUI().getNavigator() == null) {
                throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
            }
            this.getUI().getNavigator().addViewChangeListener((ViewChangeListener)this);
        }

        public void detach() {
            this.getUI().getNavigator().removeViewChangeListener((ViewChangeListener)this);
            super.detach();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            if (event.getViewName().equals(this.viewName)) {
                this.addStyleName("selected");
            } else {
                this.removeStyleName("selected");
            }
        }
    }

    class ItemButton
    extends Button {
        CssLayout compositionRoot;

        ItemButton(SideBarItemDescriptor descriptor) {
            this.setPrimaryStyleName("valo-menu-item");
            this.addStyleName(descriptor.getItemId().substring("sidebaritem_".length()));
            if (OTCSideBar.this.itemsMap.containsKey(descriptor)) {
                this.addStyleName("has-items");
            }
            this.setCaption(descriptor.getCaption());
            this.setIcon(descriptor.getIcon());
            this.setId(descriptor.getItemId());
            this.setDisableOnClick(true);
            this.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    descriptor.itemInvoked(this.getUI());
                    if (this.compositionRoot != null && OTCSideBar.this.itemsMap.containsKey(descriptor)) {
                        OTCSideBar.this.showGridItems(descriptor);
                    }
                }
                finally {
                    this.setEnabled(true);
                }
            });
        }

        public void setCompositionRoot(CssLayout compositionRoot) {
            this.compositionRoot = compositionRoot;
        }
    }

    public class DefaultItemComponentFactory
    implements AbstractSideBar.ItemComponentFactory {
        public Component createItemComponent(SideBarItemDescriptor descriptor) {
            if (descriptor instanceof SideBarItemDescriptor.ViewItemDescriptor) {
                return new ViewItemButton((SideBarItemDescriptor.ViewItemDescriptor)descriptor);
            }
            return new ItemButton(descriptor);
        }
    }

    class FilterGrid
    extends CssLayout {
        private final Label filterStatus;
        private final TextField filter;
        private Grid<DirectoryObject> itemGrid;

        public FilterGrid(SideBarItemDescriptor item, AbstractThinclientView bean) {
            this.setVisible(false);
            this.addStyleNames(new String[]{"filterGrid"});
            CssLayout filterRow = new CssLayout();
            filterRow.addStyleNames(new String[]{"filterRow"});
            this.filter = new TextField();
            this.filter.setPlaceholder("Filter");
            this.filter.addValueChangeListener(this::onFilterTextChange);
            filterRow.addComponent((Component)this.filter);
            this.filterStatus = new Label();
            this.filterStatus.addStyleName("profileItemFilterStatus");
            filterRow.addComponent((Component)this.filterStatus);
            this.addComponent((Component)filterRow);
            this.itemGrid = new Grid();
            this.itemGrid.addStyleNames(new String[]{"profileSelectionGrid"});
            this.itemGrid.addStyleName(item.getItemId().substring("sidebaritem_".length()));
            this.itemGrid.setSelectionMode(Grid.SelectionMode.SINGLE);
            SingleSelectionModel singleSelect = (SingleSelectionModel)this.itemGrid.getSelectionModel();
            singleSelect.setDeselectAllowed(false);
            this.itemGrid.addColumn(DirectoryObject::getName);
            this.itemGrid.addSelectionListener((SelectionListener & Serializable)selectionEvent -> OTCSideBar.this.showContent(bean.getViewName(), (SelectionEvent<DirectoryObject>)selectionEvent));
            this.itemGrid.removeHeaderRow(0);
            this.itemGrid.setSizeFull();
            this.itemGrid.setHeightMode(HeightMode.UNDEFINED);
            this.itemGrid.setStyleGenerator((StyleGenerator & Serializable)profile -> profile.getClass().getSimpleName());
            this.addComponent((Component)this.itemGrid);
        }

        private void onFilterTextChange(HasValue.ValueChangeEvent<String> event) {
            ListDataProvider dataProvider = (ListDataProvider)this.itemGrid.getDataProvider();
            long groupHeader = dataProvider.getItems().stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            dataProvider.setFilter((SerializablePredicate & Serializable)directoryObject -> {
                if (directoryObject instanceof ProfilePropertiesBuilder.MenuGroupProfile) {
                    return true;
                }
                return this.caseInsensitiveContains(directoryObject.getName(), (String)event.getValue());
            });
            long filteredGroupHeader = dataProvider.fetch(new Query()).filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            this.filterStatus.setCaption((long)dataProvider.size(new Query()) - filteredGroupHeader + "/" + ((long)dataProvider.getItems().size() - groupHeader));
        }

        private Boolean caseInsensitiveContains(String where, String what) {
            return where.toLowerCase().contains(what.toLowerCase());
        }

        public int getSize() {
            DataProvider dataProvider = this.itemGrid.getDataProvider();
            return dataProvider.size(new Query());
        }

        public void setItems(Set<DirectoryObject> items) {
            List<? extends DirectoryObject> groupedItems = ProfilePropertiesBuilder.createGroupedItems(items);
            long groupHeader = groupedItems.stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            ListDataProvider dataProvider = DataProvider.ofCollection(groupedItems);
            this.itemGrid.setDataProvider((DataProvider)dataProvider);
            long visibleItems = (long)dataProvider.getItems().size() - groupHeader;
            this.filterStatus.setCaption(visibleItems + "/" + items.size());
            if (visibleItems > 0L) {
                this.itemGrid.setHeightByRows((double)visibleItems);
            }
            this.filter.setValue("");
        }

        public void markSelectedItem(String directoryObjectName) {
            this.itemGrid.getDataProvider().fetch(new Query()).filter(directoryObject -> directoryObject.getName().equals(directoryObjectName)).findFirst().ifPresent(directoryObject -> this.itemGrid.getSelectionModel().select(directoryObject));
        }

        public DirectoryObject getSelectedItem() {
            return (DirectoryObject)this.itemGrid.getSelectedItems().iterator().next();
        }
    }

    public class DefaultSectionComponentFactory
    implements AbstractSideBar.SectionComponentFactory<CssLayout> {
        private AbstractSideBar.ItemComponentFactory itemComponentFactory;

        public void setItemComponentFactory(AbstractSideBar.ItemComponentFactory itemComponentFactory) {
            this.itemComponentFactory = itemComponentFactory;
        }

        public void createSection(CssLayout compositionRoot, SideBarSectionDescriptor descriptor, Collection<SideBarItemDescriptor> itemDescriptors) {
            for (SideBarItemDescriptor item : itemDescriptors) {
                Optional<Map.Entry> nameType;
                ItemButton itemComponent = (ItemButton)this.itemComponentFactory.createItemComponent(item);
                itemComponent.setCompositionRoot(compositionRoot);
                compositionRoot.addComponent((Component)itemComponent);
                if (item.getItemId().equals("sidebaritem_realmsettingsview") || !(nameType = OTCSideBar.this.sideBarUtils.getNameTypeMap().entrySet().stream().filter(entry -> item.getItemId().contains(((String)entry.getKey()).toLowerCase())).findFirst()).isPresent()) continue;
                Class sideBarItemClass = (Class)nameType.get().getValue();
                Object bean = OTCSideBar.this.sideBarUtils.getApplicationContext().getBean(sideBarItemClass);
                if (!(bean instanceof AbstractThinclientView)) continue;
                FilterGrid filterGrid = new FilterGrid(item, (AbstractThinclientView)((Object)bean));
                compositionRoot.addComponent((Component)filterGrid);
                OTCSideBar.this.itemsMap.put(item, filterGrid);
            }
        }
    }
}

