/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.op.InstallPlan;
import org.openthinclient.pkgmgr.op.InstallPlanStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaService.class);
    private final PackageManager packageManager;
    private final ApplicationService applicationService;
    private final SchemaProvider schemaProvider;
    private final RealmService realmService;

    public SchemaService(PackageManager packageManager, ApplicationService applicationService, SchemaProvider schemaProvider, RealmService realmService) {
        this.packageManager = packageManager;
        this.applicationService = applicationService;
        this.schemaProvider = schemaProvider;
        this.realmService = realmService;
    }

    public Stream<? extends Schema<?>> findAffectedSchemas(InstallPlan installPlan) {
        return installPlan.getPackageUninstallSteps().flatMap(this::getInstalledContents).filter(this::isSchemaFilePath).map(this::loadSchema).filter(Objects::nonNull);
    }

    public Collection<Application> findAffectedApplications(InstallPlan installPlan) {
        return this.findAffectedSchemas(installPlan).flatMap(schema -> this.applicationService.findAllUsingSchema(schema).stream()).collect(Collectors.toList());
    }

    private Stream<PackageInstalledContent> getInstalledContents(InstallPlanStep.PackageUninstallStep packageUninstallStep) {
        Package pkg = packageUninstallStep.getInstalledPackage();
        List contents = this.packageManager.getInstalledPackageContents(pkg);
        if (contents == null) {
            return Stream.empty();
        }
        return contents.stream();
    }

    private Schema<?> loadSchema(PackageInstalledContent packageInstalledContent) {
        Path path = packageInstalledContent.getPath();
        String profileTypeName = path.getName(1).toString();
        String schemaFileName = path.getName(2).toString();
        String schemaName = schemaFileName.substring(0, schemaFileName.length() - 4);
        ProfileType profileType = ProfileType.get(profileTypeName);
        if (profileType == null) {
            LOGGER.error("failed to map profile type name {}", (Object)profileTypeName);
            return null;
        }
        this.schemaProvider.reload();
        return this.schemaProvider.getSchema(profileType.getProfileClass(), schemaName);
    }

    protected boolean isSchemaFilePath(PackageInstalledContent packageInstalledContent) {
        if (packageInstalledContent.getType() == PackageInstalledContent.Type.DIR) {
            return false;
        }
        return this.isSchemaFilePath(packageInstalledContent.getPath());
    }

    protected boolean isSchemaFilePath(Path path) {
        if (!path.getFileName().toString().endsWith(".xml")) {
            return false;
        }
        return path.getNameCount() == 3 && path.startsWith(Paths.get("schema", "application"));
    }

    public void saveTftpPolicy(Config.BootOptions.PXEServicePolicyType policyType) {
        Realm defaultRealm = this.realmService.getDefaultRealm();
        defaultRealm.setValue("BootOptions.PXEServicePolicy", policyType.name());
        LOGGER.info("Change BootOptions.PXEServicePolicy to " + policyType.name());
        try {
            defaultRealm.getDirectory().save((Object)defaultRealm);
        }
        catch (DirectoryException e) {
            LOGGER.error("Cannot save BootOptions.PXEServicePolicy=" + policyType.name(), (Throwable)e);
        }
    }

    public static enum ProfileType {
        APPLICATION("application", Application.class),
        HARDWARE_TYPE("hardwaretype", HardwareType.class),
        DEVICE("device", Device.class),
        LOCATION("location", Location.class),
        CLIENT("client", Client.class),
        PRINTER("printer", Printer.class);

        private final String profileName;
        private final Class<?> profileClass;

        private ProfileType(String profileName, Class<?> profileClass) {
            this.profileName = profileName;
            this.profileClass = profileClass;
        }

        public static ProfileType get(String name) {
            for (ProfileType profileType : ProfileType.values()) {
                if (!profileType.getProfileName().equals(name)) continue;
                return profileType;
            }
            return null;
        }

        public Class<?> getProfileClass() {
            return this.profileClass;
        }

        public String getProfileName() {
            return this.profileName;
        }
    }
}

