/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.dashboard;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.dashboard.ContentPanel;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.PrivacyNoticeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="")
@SideBarItem(sectionId="client-management", caption="Dashboard", order=10)
@ThemeIcon(value="icon/dashboard.svg")
public class DashboardView
extends Panel
implements View {
    public static final String NAME = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardView.class);
    @Autowired
    private ClientService clientService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    private EventBus.SessionEventBus eventBus;
    private final IMessageConveyor mc;
    private CssLayout dashboardPanels;
    private ComboBox<UnrecognizedClient> macCombo;

    @Autowired
    public DashboardView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.setSizeFull();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.eventBus = eventBus;
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_HEADER, new Object[0])));
    }

    @PostConstruct
    public void init() {
        VerticalLayout root = new VerticalLayout();
        root.addComponents(new Component[]{this.buildContent(), new PrivacyNoticeInfo()});
        this.setContent((Component)root);
    }

    private Component buildContent() {
        this.dashboardPanels = new CssLayout();
        this.dashboardPanels.addStyleName("dashboard-panels");
        Responsive.makeResponsive((Component[])new Component[]{this.dashboardPanels});
        InfoContentPanel thinclientInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), new ThemeResource("icon/logo-white.svg"), this.getInfoContent(() -> this.clientService.findAll()));
        InfoContentPanel applicationInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), new ThemeResource("icon/packages-white.svg"), this.getInfoContent(() -> this.applicationService.findAll()));
        InfoContentPanel devicesInfo = new InfoContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DEVICE_HEADER, new Object[0]), new ThemeResource("icon/display-white.svg"), this.getInfoContent(() -> this.deviceService.findAll()));
        this.dashboardPanels.addComponents(new Component[]{thinclientInfo, applicationInfo, devicesInfo});
        UnregisteredClientsPanel ucp = new UnregisteredClientsPanel("Unregistered " + this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), (Resource)new ThemeResource("icon/logo-white.svg"));
        this.dashboardPanels.addComponent((Component)ucp);
        ContentPanel helpPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_TITLE, new Object[0]), (Resource)new ThemeResource("icon/help.svg"));
        helpPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_CONTENT, new Object[0]), ContentMode.HTML));
        ContentPanel toolsPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_TITLE, new Object[0]), (Resource)new ThemeResource("icon/meter.svg"));
        toolsPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_CONTENT, new Object[0]), ContentMode.HTML));
        this.dashboardPanels.addComponents(new Component[]{helpPanel, toolsPanel});
        return this.dashboardPanels;
    }

    private String getInfoContent(Supplier<Set> contentSupplier) {
        String info = NAME;
        try {
            info = String.valueOf(contentSupplier.get().size());
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load content: " + e.getMessage());
        }
        return info;
    }

    @EventBusListenerMethod
    public void updatePXEClientList(DashboardEvent.PXEClientListRefreshEvent event) {
        try {
            Set clients = this.unrecognizedClientService.findAll();
            LOGGER.debug("Update PXE-client list, size {}", (Object)clients.size());
            this.macCombo.setDataProvider(new ListDataProvider((Collection)clients));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load content: " + e.getMessage());
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    class UnregisteredClientsPanel
    extends ContentPanel {
        public UnregisteredClientsPanel(String title, Resource resource) {
            super(title, resource);
            this.setSpacing(false);
            this.setHeight(120.0f, Sizeable.Unit.PIXELS);
            this.addImageStyleName("dashboard-panel-unregistered-clients-image-circle");
            DashboardView.this.macCombo = new ComboBox();
            DashboardView.this.macCombo.setPlaceholder(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC, new Object[0]));
            DashboardView.this.macCombo.setEmptySelectionAllowed(false);
            try {
                DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot load content: " + e.getMessage());
            }
            DashboardView.this.macCombo.setItemCaptionGenerator(UnrecognizedClient::getMacAddress);
            DashboardView.this.macCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> UI.getCurrent().getNavigator().navigateTo("client_view/register/" + ((UnrecognizedClient)event.getValue()).getMacAddress()));
            HorizontalLayout hl = new HorizontalLayout();
            Button btn = new Button(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_BUTTON_UPDATE_CAPTION, new Object[0]));
            btn.addStyleName("dashboard-panel-unregistered-clients-button");
            btn.setIcon((Resource)VaadinIcons.REFRESH);
            btn.addStyleName("borderless");
            btn.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot load content: " + e.getMessage());
                }
            });
            Button btnCleanClients = new Button();
            btnCleanClients.addStyleName("dashboard-panel-unregistered-clients-clean-button");
            btnCleanClients.setIcon((Resource)VaadinIcons.TRASH);
            btnCleanClients.addStyleName("borderless");
            btnCleanClients.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    DashboardView.this.unrecognizedClientService.findAll().forEach(directoryObject -> {
                        Realm realm = directoryObject.getRealm();
                        try {
                            realm.getDirectory().delete(directoryObject);
                        }
                        catch (DirectoryException e) {
                            LOGGER.info("Cannot delete unrecognizedClient: " + directoryObject + ": " + e.getMessage());
                        }
                    });
                    DashboardView.this.macCombo.setDataProvider(new ListDataProvider((Collection)DashboardView.this.unrecognizedClientService.findAll()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot load content: " + e.getMessage());
                }
            });
            hl.addComponents(new Component[]{btn, btnCleanClients});
            this.addComponent((Component)hl);
            this.addComponent((Component)DashboardView.this.macCombo);
        }
    }

    class InfoContentPanel
    extends ContentPanel {
        public InfoContentPanel(String message, ThemeResource themeResource, String caption) {
            super(message, (Resource)themeResource);
            this.setHeight(70.0f, Sizeable.Unit.PIXELS);
            this.addImageStyleName("dashboard-panel-image-circle");
            if (caption != null) {
                Label label = new Label(caption);
                label.addStyleName("content-panel-number-large");
                this.addComponent((Component)label);
            }
        }
    }
}

