/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.filebrowser;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.Page;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.openthinclient.web.filebrowser.FileBrowserView;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadSubWindow
extends Window {
    private static final long serialVersionUID = 641733612432869212L;
    private MyReceiver receiver = new MyReceiver();
    private Path doc;
    private Label fileUploadInfoLabel;
    private FileBrowserView fileBrowserView;
    private IMessageConveyor mc;

    public FileUploadSubWindow(FileBrowserView fileBrowserView, Path doc, Path managerHomePath) {
        this.fileBrowserView = fileBrowserView;
        this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.doc = doc == null ? managerHomePath : (Files.isDirectory(doc, new LinkOption[0]) ? doc : doc.getParent());
        this.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_UPLOAD_CAPTION, new Object[]{this.doc.getFileName()}));
        this.setHeight("140px");
        this.setWidth("500px");
        this.center();
        VerticalLayout subContent = new VerticalLayout();
        subContent.setMargin(true);
        subContent.setSizeFull();
        this.setContent((Component)subContent);
        Upload upload = new Upload(null, (Upload.Receiver)this.receiver);
        upload.addSucceededListener((Upload.SucceededListener)this.receiver);
        upload.setImmediateMode(true);
        subContent.addComponent((Component)upload);
        this.fileUploadInfoLabel = new Label();
        this.fileUploadInfoLabel.setEnabled(false);
        subContent.addComponent((Component)this.fileUploadInfoLabel);
    }

    public class MyReceiver
    implements Upload.Receiver,
    Upload.SucceededListener {
        private static final long serialVersionUID = -5844542658116931976L;
        private final transient Logger LOGGER = LoggerFactory.getLogger(MyReceiver.class);
        public Path file;

        public OutputStream receiveUpload(String filename, String mimeType) {
            FileOutputStream fos = null;
            try {
                this.file = FileUploadSubWindow.this.doc.resolve(filename);
                fos = new FileOutputStream(this.file.toFile());
            }
            catch (FileNotFoundException e) {
                this.LOGGER.error("Could not open file", (Throwable)e);
                new Notification(FileUploadSubWindow.this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_UPLOAD_FAIL, new Object[0]), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                return null;
            }
            return fos;
        }

        public void uploadSucceeded(Upload.SucceededEvent event) {
            FileUploadSubWindow.this.fileUploadInfoLabel.setValue(FileUploadSubWindow.this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_UPLOAD_SUCCESS, new Object[]{this.file.getFileName()}));
            FileUploadSubWindow.this.fileUploadInfoLabel.setEnabled(true);
            FileUploadSubWindow.this.fileBrowserView.refresh(this.file);
        }
    }
}

