/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.Registration;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.AvailablePackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageActionOverviewPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsListPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.presenter.UpdateablePackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.PackageActionOverviewView;
import org.openthinclient.web.pkgmngr.ui.view.PackageListMasterDetailsView;
import org.openthinclient.web.pkgmngr.ui.view.PackageManagerMainView;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="package-management", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION", order=1)
public class PackageManagerMainNavigatorView
extends Panel
implements View {
    private static final long serialVersionUID = -1596921762830560217L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageManagerMainNavigatorView.class);
    private final PackageManagerMainView mainView;
    private final PackageListMasterDetailsPresenter availablePackagesPresenter;
    private final PackageListMasterDetailsPresenter installedPackagesPresenter;
    private final PackageListMasterDetailsPresenter updateablePackagesPresenter;
    private final PackageManager packageManager;
    private final SchemaService schemaService;
    private final ClientService clientService;
    private final Registration handler;
    private final ApplicationService applicationService;
    private final IMessageConveyor mc;

    @Autowired
    public PackageManagerMainNavigatorView(PackageManager packageManager, PackageManagerExecutionEngine packageManagerExecutionEngine, SchemaService schemaService, ApplicationService applicationService, ClientService clientService, EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.packageManager = packageManager;
        this.schemaService = schemaService;
        this.applicationService = applicationService;
        this.clientService = clientService;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.mainView = new PackageManagerMainView();
        this.availablePackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.INSTALL, this.mainView.getAvailablePackagesView());
        this.updateablePackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.UPDATE, this.mainView.getUpdateablePackagesView());
        this.installedPackagesPresenter = this.createPresenter(PackageDetailsListPresenter.Mode.UNINSTALL, this.mainView.getInstalledPackagesView());
        this.setSizeFull();
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION, new Object[0])));
        this.handler = packageManagerExecutionEngine.addTaskFinalizedHandler(e -> this.bindPackageLists());
    }

    @PostConstruct
    private void init() {
        this.addStyleName("package-manager");
        this.setContent(this.buildContent());
    }

    private Component buildContent() {
        this.mainView.setTabCaption((Component)this.mainView.getAvailablePackagesView(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_AVAILABLEPACKAGES, new Object[0]));
        this.mainView.setTabCaption((Component)this.mainView.getUpdateablePackagesView(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_UPDATEABLEPACKAGES, new Object[0]));
        this.mainView.setTabCaption((Component)this.mainView.getInstalledPackagesView(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_TAB_INSTALLEDPACKAGES, new Object[0]));
        this.mainView.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> {
            this.updateablePackagesPresenter.refreshUpdatePanel();
            this.availablePackagesPresenter.refreshUpdatePanel();
        });
        this.mainView.getInstalledPackagesView().hideSourceUpdatePanel();
        return this.mainView;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.bindPackageLists();
    }

    private void bindPackageLists() {
        this.bindPackageList(this.availablePackagesPresenter, () -> ((PackageManager)this.packageManager).getInstallablePackagesWithoutInstalledOfSameVersion());
        this.bindPackageList(this.installedPackagesPresenter, () -> ((PackageManager)this.packageManager).getInstalledPackages());
        this.bindPackageList(this.updateablePackagesPresenter, () -> ((PackageManager)this.packageManager).getUpdateablePackages());
    }

    private PackageListMasterDetailsPresenter createPresenter(PackageDetailsListPresenter.Mode mode, PackageListMasterDetailsView masterDetailsView) {
        PackageActionOverviewView packageActionOverviewView = new PackageActionOverviewView();
        masterDetailsView.getDetailsContainer().addComponent((Component)packageActionOverviewView);
        PackageDetailsListPresenter packageDetailsListPresenter = new PackageDetailsListPresenter(mode, new PackageActionOverviewPresenter(packageActionOverviewView), this.packageManager, this.schemaService, this.applicationService, this.clientService);
        Consumer<Collection<Package>> presenter = packageDetailsListPresenter::setPackages;
        if (mode == PackageDetailsListPresenter.Mode.INSTALL) {
            return new AvailablePackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
        }
        if (mode == PackageDetailsListPresenter.Mode.UPDATE) {
            return new UpdateablePackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
        }
        return new PackageListMasterDetailsPresenter(masterDetailsView, presenter, this.packageManager, this.clientService);
    }

    private void bindPackageList(PackageListMasterDetailsPresenter presenter, Callable<Collection<Package>> packagesProvider) {
        try {
            presenter.setPackages(packagesProvider.call());
        }
        catch (Exception e) {
            presenter.showPackageListLoadingError(e);
            LOGGER.error("Failed to load package list", (Throwable)e);
        }
    }

    @PreDestroy
    public void cleanup() {
        LOGGER.debug("Cleanup {} and unregister {}", (Object)this, (Object)this.handler);
        this.handler.unregister();
    }
}

