/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="applicationgroup_view", ui={ManagerUI.class})
@ThemeIcon(value="icon/applicationgroup-white.svg")
public final class ApplicationGroupView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationGroupView.class);
    public static final String NAME = "applicationgroup_view";
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public ApplicationGroupView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    public void setup() {
        this.showCreateApplicationGroupAction();
    }

    @Override
    public HashSet getAllItems() {
        return (HashSet)this.applicationGroupService.findAll();
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(ApplicationGroup.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(ApplicationGroup.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) {
        ProfilePanel profilePanel = new ProfilePanel(directoryObject.getName(), directoryObject.getClass());
        OtcPropertyGroup configuration = this.createUserMetadataPropertyGroup((ApplicationGroup)directoryObject);
        this.addProfileNameAlreadyExistsValidator(configuration);
        DirectoryObjectPanelPresenter ppp = new DirectoryObjectPanelPresenter(this, profilePanel, directoryObject);
        ppp.setItemGroups(Arrays.asList(configuration, new OtcPropertyGroup(null, null)));
        ppp.onValuesWritten(profilePanel1 -> this.saveProfile(directoryObject, ppp));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        ApplicationGroup applicationGroup = (ApplicationGroup)item;
        refPresenter.showReference(applicationGroup.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), this.applicationService.findAll(), Application.class, values -> this.saveApplicationGroupReference(applicationGroup, (List<Item>)values), null, false);
        Set allApplicationGroups = this.applicationGroupService.findAll();
        allApplicationGroups.remove(applicationGroup);
        refPresenter.showReference(applicationGroup.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveApplicationGroup2GroupReference(applicationGroup, (List<Item>)values), this.getApplicationsForApplicationGroupFunction(applicationGroup), false);
        return referencesPanel;
    }

    private void saveApplicationGroupReference(ApplicationGroup applicationGroup, List<Item> values) {
        List<Application> oldValues = this.applicationService.findAll().stream().filter(application -> application.getMembers().contains(applicationGroup)).collect(Collectors.toList());
        LOGGER.debug(applicationGroup.getName() + " applications: {}", oldValues);
        oldValues.forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from applicationGroup: " + oldItem);
                if (oldItem.getMembers().contains(applicationGroup)) {
                    oldItem.getMembers().remove(applicationGroup);
                    this.applicationService.save((DirectoryObject)oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            Application application = (Application)this.applicationService.findByName(newValue.getName());
            if (application != null) {
                if (!oldValues.contains(application)) {
                    LOGGER.info("Add ApplicationGroup to members of: " + newValue);
                    applicationGroup.getApplications().add(application);
                    application.getMembers().add(applicationGroup);
                    this.applicationService.save((DirectoryObject)application);
                }
            } else {
                LOGGER.info("Application not found for " + newValue);
            }
        });
    }

    private void saveApplicationGroup2GroupReference(ApplicationGroup applicationGroup, List<Item> values) {
        ApplicationGroup group = (ApplicationGroup)this.applicationGroupService.findByName(applicationGroup.getName());
        Set oldValues = group.getApplicationGroups();
        LOGGER.debug(applicationGroup.getName() + " old application-groups: {}", (Object)oldValues);
        oldValues.forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from applicationGroup: " + oldItem);
                if (oldItem.getMembers().contains(applicationGroup)) {
                    oldItem.getMembers().remove(applicationGroup);
                    this.applicationGroupService.save((DirectoryObject)oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            ApplicationGroup applicationGroup1 = (ApplicationGroup)this.applicationGroupService.findByName(newValue.getName());
            if (applicationGroup1 != null) {
                if (!oldValues.contains(applicationGroup1)) {
                    LOGGER.info("Add ApplicationGroup to members of: " + newValue);
                    applicationGroup.getApplicationGroups().add(applicationGroup1);
                    applicationGroup1.getMembers().add(applicationGroup);
                    this.applicationGroupService.save((DirectoryObject)applicationGroup1);
                }
            } else {
                LOGGER.info("Application not found for " + newValue);
            }
        });
    }

    private OtcPropertyGroup createUserMetadataPropertyGroup(ApplicationGroup applicationGroup) {
        OtcPropertyGroup configuration = new OtcPropertyGroup(null, new OtcProperty[0]);
        configuration.setDisplayHeaderLabel(false);
        OtcTextProperty name = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_TIP, new Object[0]), "name", applicationGroup.getName());
        ItemConfiguration nameConfiguration = new ItemConfiguration("name", applicationGroup.getName());
        nameConfiguration.addValidator((AbstractValidator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_VALIDATOR, new Object[0]), Integer.valueOf(1), Integer.valueOf(255)));
        name.setConfiguration(nameConfiguration);
        configuration.addProperty(name);
        OtcTextProperty desc = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]), null, "description", applicationGroup.getDescription());
        ItemConfiguration descConfig = new ItemConfiguration("description", applicationGroup.getDescription());
        desc.setConfiguration(descConfig);
        configuration.addProperty(desc);
        return configuration;
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.applicationGroupService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.applicationGroupService.save((DirectoryObject)((ApplicationGroup)profile));
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction(ApplicationGroup applicationGroup) {
        return item -> {
            Optional<ApplicationGroup> first = applicationGroup.getApplicationGroups().stream().filter(ag -> ag.getName().equals(item.getName())).findFirst();
            if (first.isPresent()) {
                Stream<Application> stream = first.get().getApplications().stream().sorted(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase));
                return stream.map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    public void showProfileMetadata(ApplicationGroup profile) {
        OtcPropertyGroup propertyGroup = this.createUserMetadataPropertyGroup(profile);
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_APPLICATIONGROUP_HEADER, new Object[0]), profile.getClass());
        DirectoryObjectPanelPresenter ppp = new DirectoryObjectPanelPresenter(this, profilePanel, (DirectoryObject)profile);
        ppp.setItemGroups(Arrays.asList(propertyGroup, new OtcPropertyGroup(null, null)));
        ppp.expandMetaData();
        ppp.hideCopyButton();
        ppp.hideDeleteButton();
        this.showProfileMetadataPanel(profilePanel);
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        String[] params;
        if (event.getParameters() != null && (params = event.getParameters().split("/")).length == 1 && params[0].equals("create")) {
            switch (event.getViewName()) {
                case "applicationgroup_view": {
                    this.showProfileMetadata(new ApplicationGroup());
                }
            }
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

