/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.ui.BorderStyle;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.api.rest.appliance.TokenManager;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientGroupService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.openthinclient.web.thinclient.util.ClientIPAddressFinder;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="client_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_CLIENT_HEADER", order=20)
@ThemeIcon(value="icon/thinclient.svg")
public final class ClientView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientView.class);
    public static final String NAME = "client_view";
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ClientGroupService clientGroupService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    @Qualifier(value="deviceSideBar")
    private OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public ClientView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_CLIENT_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    public void setup() {
        this.showCreateClientAction();
        this.addOverviewItemlistPanel(ConsoleWebMessages.UI_CLIENT_HEADER, this.getAllItems());
    }

    @Override
    public Set getAllItems() {
        try {
            return this.clientService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Client.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(Client.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + type + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.addPanelCaptionComponent(this.createVNCButton());
        presenter.addPanelCaptionComponent(this.createLOGButton());
        otcPropertyGroups.remove(0);
        otcPropertyGroups.add(0, this.createClientMetadataPropertyGroup((Client)profile, presenter));
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Client client = (Client)item;
        Map associatedObjects = client.getAssociatedObjects();
        Set devices = (Set)associatedObjects.get(Device.class);
        Set allDevices = this.deviceService.findAll();
        refPresenter.showDeviceAssociations(allDevices, devices, values -> this.saveAssociations((AssociatedObjectsProvider)client, (List<Item>)values, allDevices, Device.class));
        Set allClientGroups = this.clientGroupService.findAll();
        refPresenter.showReference(client.getClientGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENTGROUP_HEADER, new Object[0]), allClientGroups, ClientGroup.class, values -> this.saveReference(item, (List<Item>)values, allClientGroups, ClientGroup.class));
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference(client.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveReference(item, (List<Item>)values, allApplicationGroups, ApplicationGroup.class), this.getApplicationsForApplicationGroupFunction(client), false);
        Set allApplications = this.applicationService.findAll();
        refPresenter.showReference(client.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, Application.class, values -> this.saveReference(item, (List<Item>)values, allApplications, Application.class));
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(client.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, Printer.class, values -> this.saveReference(item, (List<Item>)values, allPrinters, Printer.class));
        return referencesPanel;
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction(Client client) {
        return item -> {
            Optional<ApplicationGroup> first = client.getApplicationGroups().stream().filter(ag -> ag.getName().equals(item.getName())).findFirst();
            if (first.isPresent()) {
                Stream<Application> stream = first.get().getApplications().stream().sorted(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase));
                return stream.map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    private Component createVNCButton() {
        Button button = new Button();
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_VNC, new Object[0]));
        button.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_VNC_LABEL, new Object[0]));
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        button.addClickListener(this::openNoVncInNewBrowserWindow);
        return button;
    }

    private Component createLOGButton() {
        Button button = new Button();
        button.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_CLIENTLOG, new Object[0]));
        button.setIcon((Resource)VaadinIcons.FILE_TEXT_O);
        button.addStyleName("borderless-colored");
        button.addStyleName("small");
        button.addStyleName("icon-only");
        button.addClickListener(this::showClientLogs);
        return button;
    }

    @Override
    protected ProfilePanel createProfileMetadataPanel(Profile p) {
        Client profile = (Client)p;
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_CLIENT_HEADER, new Object[0]), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, (Profile)profile);
        presenter.hideCopyButton();
        presenter.hideDeleteButton();
        OtcPropertyGroup configuration = this.createClientMetadataPropertyGroup(profile, presenter);
        presenter.setItemGroups(Arrays.asList(configuration, new OtcPropertyGroup(null, null)));
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, p));
        return profilePanel;
    }

    private OtcPropertyGroup createClientMetadataPropertyGroup(Client profile, ProfilePanelPresenter presenter) {
        OtcPropertyGroup configuration = this.builder.createProfileMetaDataGroup(this.getSchemaNames(), (Profile)profile);
        this.addProfileNameAlreadyExistsValidator(configuration);
        configuration.getProperty("name").ifPresent(nameProperty -> nameProperty.getConfiguration().addValidator((AbstractValidator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_THINCLIENT_NAME_REGEXP, new Object[0]), "^[a-zA-Z0-9][a-zA-Z0-9\\-\\.]+[a-zA-Z0-9]$")));
        OtcTextProperty macaddress = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC_TIP, new Object[0]), "macaddress", profile.getMacAddress());
        ItemConfiguration macaddressConfiguration = new ItemConfiguration("macaddress", profile.getMacAddress());
        macaddressConfiguration.addValidator((AbstractValidator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC_VALIDATOR_ADDRESS, new Object[0]), "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"));
        macaddress.setConfiguration(macaddressConfiguration);
        configuration.addProperty(macaddress);
        OtcOptionProperty locationProp = new OtcOptionProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION_HEADER, new Object[0]), null, "location", profile.getLocation() != null ? profile.getLocation().getDn() : null, this.locationService.findAll().stream().map(o -> new SelectOption(o.getName(), o.getDn())).collect(Collectors.toList()));
        ItemConfiguration locationConfig = new ItemConfiguration("location", profile.getLocation() != null ? profile.getLocation().getDn() : null);
        locationConfig.setRequired(true);
        ((OtcProperty)locationProp).setConfiguration(locationConfig);
        configuration.addProperty(locationProp);
        OtcOptionProperty hwProp = new OtcOptionProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE_HEADER, new Object[0]), null, "hwtype", profile.getHardwareType() != null ? profile.getHardwareType().getDn() : null, this.hardwareTypeService.findAll().stream().map(o -> new SelectOption(o.getName(), o.getDn())).collect(Collectors.toList()));
        ItemConfiguration hwtypeConfig = new ItemConfiguration("hwtype", profile.getHardwareType() != null ? profile.getHardwareType().getDn() : null);
        hwtypeConfig.setRequired(true);
        ((OtcProperty)hwProp).setConfiguration(hwtypeConfig);
        configuration.addProperty(hwProp);
        return configuration;
    }

    @Override
    public void saveValues(ProfilePanelPresenter profilePanelPresenter, Profile profile) {
        LOGGER.info("Save values for client: " + profile);
        Client client = (Client)profile;
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            String current;
            ItemConfiguration bean = otcProperty.getConfiguration();
            String propertyKey = otcProperty.getKey();
            String org = client.getValue(propertyKey);
            String string = current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
            if (!StringUtils.equals((CharSequence)org, (CharSequence)current)) {
                if (current != null) {
                    LOGGER.info(" Apply value for " + propertyKey + "=" + org + " with new value '" + current + "'");
                    switch (propertyKey) {
                        case "iphostnumber": {
                            client.setIpHostNumber(current);
                            break;
                        }
                        case "macaddress": {
                            client.setMacAddress(current != null ? current : "");
                            break;
                        }
                        case "location": {
                            client.setLocation(this.locationService.findAll().stream().filter(l -> l.getDn().equals(current)).findFirst().get());
                            break;
                        }
                        case "hwtype": {
                            client.setHardwareType(this.hardwareTypeService.findAll().stream().filter(h -> h.getDn().equals(current)).findFirst().get());
                            break;
                        }
                        case "type": {
                            client.setSchema(this.getSchema(current));
                            client.getProperties().setName("client");
                            client.getProperties().setDescription(current);
                            break;
                        }
                        case "name": {
                            client.setName(current);
                            break;
                        }
                        case "description": {
                            client.setDescription(current);
                            break;
                        }
                        default: {
                            client.setValue(propertyKey, current);
                            break;
                        }
                    }
                } else {
                    LOGGER.info(" Remove empty value for " + propertyKey);
                    client.removeValue(propertyKey);
                }
            } else {
                LOGGER.info(" Unchanged " + propertyKey + "=" + org);
            }
        }));
        boolean success = this.saveProfile((DirectoryObject)client, profilePanelPresenter);
        if (success) {
            this.selectItem((DirectoryObject)client);
            this.navigateTo((DirectoryObject)profile);
        }
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        Client profile = (Client)this.clientService.findByName(name);
        if (profile != null && profile.getValue("macaddress") != null) {
            ClientIPAddressFinder.findIPAddress(profile.getValue("macaddress"), this.managerHome.getLocation()).ifPresent(arg_0 -> ((Client)profile).setIpHostNumber(arg_0));
        }
        return (T)profile;
    }

    @Override
    public void save(DirectoryObject profile) throws ProfileNotSavedException {
        LOGGER.info("Save client: " + profile);
        this.clientService.save((DirectoryObject)((Client)profile));
        String macAddress = ((Client)profile).getValue("macaddress");
        Optional<UnrecognizedClient> optionalUnrecognizedClient = this.unrecognizedClientService.findAll().stream().filter(unrecognizedClient -> unrecognizedClient.getMacAddress().equals(macAddress)).findFirst();
        if (optionalUnrecognizedClient.isPresent()) {
            Realm realm = optionalUnrecognizedClient.get().getRealm();
            try {
                realm.getDirectory().delete((Object)optionalUnrecognizedClient.get());
            }
            catch (DirectoryException e) {
                throw new ProfileNotSavedException("Cannot delete object " + profile, (Exception)((Object)e));
            }
        }
    }

    private void showClientLogs(Button.ClickEvent event) {
        String macAddress = ((Client)this.getSelectedItem()).getMacAddress();
        Path logs = this.managerHome.getLocation().toPath().resolve("logs").resolve("syslog.log");
        UI.getCurrent().addWindow((Window)new FileContentWindow(logs, macAddress));
    }

    private void openNoVncInNewBrowserWindow(Button.ClickEvent event) {
        String ipHostNumber = ((Client)this.getFreshProfile(this.getSelectedItem().getName())).getIpHostNumber();
        boolean isNoVNCConsoleEncrypted = false;
        String noVNCConsolePort = "5900";
        String noVNCConsoleAutoconnect = "true";
        String noVNCConsoleAllowfullscreen = "true";
        ExternalResource tr = new ExternalResource("/VAADIN/themes/openthinclient/novnc/vnc.html?host=" + ipHostNumber + "&port=" + noVNCConsolePort + "&encrypt=" + (isNoVNCConsoleEncrypted ? "1" : "0") + "&allowfullscreen=" + noVNCConsoleAllowfullscreen + "&autoconnect=" + noVNCConsoleAutoconnect + "&path=?token=" + this.tokenManager.createToken(VaadinRequest.getCurrent().getRemoteAddr()));
        Page.getCurrent().open(tr.getURL(), "_blank", 800, 600, BorderStyle.DEFAULT);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }

    public DirectoryObject getSelectedItem() {
        return this.deviceSideBar.getSelectedItem(NAME);
    }

    class FileContentWindow
    extends Window {
        public FileContentWindow(Path doc, String filter) {
            MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
            this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
            this.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_VIEWFILE_CAPTION, new Object[]{doc.getFileName()}));
            this.setHeight("400px");
            this.setWidth("500px");
            this.setModal(true);
            this.center();
            VerticalLayout subContent = new VerticalLayout();
            subContent.setMargin(true);
            subContent.setSizeFull();
            this.setContent((Component)subContent);
            TextArea text = new TextArea();
            try {
                List collect = Files.readAllLines(doc.toAbsolutePath()).stream().filter(l -> l.contains(filter)).collect(Collectors.toList());
                if (collect.size() == 0) {
                    collect.add("NoEntrysForTC" + filter);
                }
                text.setValue(String.join((CharSequence)"\n", collect));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read file " + doc.toAbsolutePath());
            }
            text.setSizeFull();
            subContent.addComponent((Component)text);
        }
    }
}

