/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="device_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_DEVICE_HEADER", order=50)
@ThemeIcon(value="icon/device.svg")
public final class DeviceView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceView.class);
    public static final String NAME = "device_view";
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public DeviceView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_DEVICE_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    private void setup() {
        this.showCreateDeviceAction();
        this.addOverviewItemlistPanel(ConsoleWebMessages.UI_DEVICE_HEADER, this.getAllItems());
    }

    @Override
    public Set getAllItems() {
        try {
            return this.deviceService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Device.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(Device.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + type + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        Profile profile = (Profile)item;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = ((Device)profile).getMembers();
        Set allClients = this.clientService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, Client.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allClients, Client.class));
        Set allHwTypes = this.hardwareTypeService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE_HEADER, new Object[0]), allHwTypes, HardwareType.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allHwTypes, HardwareType.class));
        return referencesPanel;
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.deviceService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.deviceService.save((DirectoryObject)((Device)profile));
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

