/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="hardwaretype_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_HWTYPE_HEADER", order=70)
@ThemeIcon(value="icon/hardwaretype.svg")
public final class HardwaretypeView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractThinclientView.class);
    public static final String NAME = "hardwaretype_view";
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public HardwaretypeView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_HWTYPE_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    private void setup() {
        this.showCreateHardwareTypeAction();
        this.addOverviewItemlistPanel(ConsoleWebMessages.UI_HWTYPE_HEADER, this.getAllItems());
    }

    @Override
    public Set getAllItems() {
        try {
            return this.hardwareTypeService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(HardwareType.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(HardwareType.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + type + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setDeleteMandate(this.createDeleteMandateFunction());
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(HardwareType.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        HardwareType hardwareType = (HardwareType)profile;
        Set members = hardwareType.getMembers();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]) + " (readonly)", Collections.emptySet(), Client.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, Collections.emptySet(), Client.class), null, true);
        Map associatedObjects = hardwareType.getAssociatedObjects();
        Set devices = (Set)associatedObjects.get(Device.class);
        Set all = this.deviceService.findAll();
        refPresenter.showDeviceAssociations(all, devices, values -> this.saveAssociations((AssociatedObjectsProvider)hardwareType, (List<Item>)values, all, Device.class));
        return referencesPanel;
    }

    private Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return directoryObject -> {
            HardwareType hwtype = (HardwareType)directoryObject;
            if (hwtype.getMembers().size() > 0) {
                return new DeleteMandate(false, this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_HWTYPE_DENIED, new Object[0]));
            }
            return new DeleteMandate(true, "");
        };
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.hardwareTypeService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.hardwareTypeService.save((DirectoryObject)((HardwareType)profile));
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

