/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.GroupNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.PasswordNode;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.SectionNode;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.property.OtcBooleanProperty;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePropertiesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePropertiesBuilder.class);

    public List<OtcPropertyGroup> getOtcPropertyGroups(String[] schemaNames, Profile profile) throws BuildProfileException {
        List<OtcPropertyGroup> propertyGroups = this.createPropertyStructure(profile);
        this.bindModel2Properties(profile, propertyGroups);
        propertyGroups.add(0, this.createProfileMetaDataGroup(schemaNames, profile));
        return propertyGroups;
    }

    private void bindModel2Properties(Profile profile, List<OtcPropertyGroup> propertyGroups) {
        propertyGroups.forEach(otcPropertyGroup -> {
            otcPropertyGroup.getOtcProperties().forEach(otcProperty -> {
                String profileValue = profile.getValue(otcProperty.getKey());
                ItemConfiguration ic = new ItemConfiguration(otcProperty.getKey(), profileValue);
                otcProperty.setConfiguration(ic);
            });
            this.bindModel2Properties(profile, otcPropertyGroup.getGroups());
        });
    }

    private List<OtcPropertyGroup> createPropertyStructure(Profile profile) throws BuildProfileException {
        ArrayList<OtcPropertyGroup> properties = new ArrayList<OtcPropertyGroup>();
        Schema schema = null;
        try {
            schema = profile.getSchema(profile.getRealm());
            OtcPropertyGroup group = new OtcPropertyGroup(null, new OtcProperty[0]);
            schema.getChildren().forEach(node -> this.extractChildren((Node)node, group, profile));
            properties.add(group);
        }
        catch (SchemaLoadingException e) {
            MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
            throw new BuildProfileException(mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_SCHEMA_NOT_LOADED, new Object[]{profile.getName()}), (Exception)((Object)e));
        }
        catch (Exception e) {
            MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
            if (schema == null) {
                throw new BuildProfileException(mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_SCHEMA_NOT_LOADED, new Object[]{profile.getName()}), e);
            }
            throw new BuildProfileException(mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_UNEXPECTED_ERROR, new Object[]{e.getMessage()}), e);
        }
        return properties;
    }

    private void extractChildren(Node node, OtcPropertyGroup group, Profile profile) {
        String value = profile.getValue(node.getKey());
        if (node instanceof ChoiceNode) {
            List options = ((ChoiceNode)node).getOptions();
            if (this.isProbablyBooleanProperty(options)) {
                group.addProperty(new OtcBooleanProperty(node.getLabel(), this.prepareTip(node.getTip()), node.getKey(), value != null ? value : ((ChoiceNode)node).getValue(), ((ChoiceNode.Option)options.get(0)).getValue(), ((ChoiceNode.Option)options.get(1)).getValue()));
            } else {
                group.addProperty(new OtcOptionProperty(node.getLabel(), this.prepareTip(node.getTip()), node.getKey(), value != null ? value : ((ChoiceNode)node).getValue(), options.stream().map(o -> new SelectOption(o.getLabel(), o.getValue())).collect(Collectors.toList())));
            }
        } else if (node instanceof PasswordNode) {
            group.addProperty(new OtcPasswordProperty(node.getLabel(), this.prepareTip(node.getTip()), node.getKey(), value != null ? value : ((EntryNode)node).getValue()));
        } else if (node instanceof EntryNode) {
            group.addProperty(new OtcTextProperty(node.getLabel(), this.prepareTip(node.getTip()), node.getKey(), value != null ? value : ((EntryNode)node).getValue()));
        } else if (node instanceof GroupNode || node instanceof SectionNode) {
            OtcPropertyGroup group1 = new OtcPropertyGroup(node.getLabel(), new OtcProperty[0]);
            node.getChildren().forEach(n -> this.extractChildren((Node)n, group1, profile));
            group.addGroup(group1);
        }
    }

    public OtcPropertyGroup createProfileMetaDataGroup(String[] schemaNames, Profile profile) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        OtcPropertyGroup group = new OtcPropertyGroup(null, new OtcProperty[0]);
        group.setDisplayHeaderLabel(false);
        OtcTextProperty property = new OtcTextProperty(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_NAME_LABEL, new Object[0]), null, "name", profile.getName(), profile.getName());
        property.getConfiguration().addValidator((AbstractValidator)new StringLengthValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_VALIDATOR, new Object[0]), Integer.valueOf(3), Integer.valueOf(255)));
        property.getConfiguration().addValidator((AbstractValidator)new RegexpValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_REGEXP, new Object[0]), "[a-zA-Z0-9\\s-_\\p{Sc}\\(\\)]+"));
        group.addProperty(property);
        group.addProperty(new OtcTextProperty(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]), null, "description", profile.getDescription(), profile.getDescription()));
        String schemaName = null;
        if (profile.getRealm() != null) {
            schemaName = profile.getSchema(profile.getRealm()).getName();
        }
        List<SelectOption> selectOptions = Arrays.stream(schemaNames).map(o -> new SelectOption((String)o, (String)o)).collect(Collectors.toList());
        OtcOptionProperty optionProperty = new OtcOptionProperty(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_TYPE_LABEL, new Object[0]), mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_TYPE_TIP, new Object[0]), "type", schemaName != null ? schemaName : (selectOptions.size() == 1 ? selectOptions.get(0).getValue() : null), selectOptions);
        ItemConfiguration itemConfiguration = new ItemConfiguration(profile.getClass().getSimpleName().toLowerCase(), schemaName);
        itemConfiguration.disable();
        optionProperty.setConfiguration(itemConfiguration);
        group.addProperty(optionProperty);
        return group;
    }

    private String prepareTip(String tip) {
        if (tip != null) {
            return tip.replaceAll("<html>|</html>|<br>|<b>|</b>", "");
        }
        return null;
    }

    private boolean isProbablyBooleanProperty(List<ChoiceNode.Option> options) {
        if (options.size() == 2) {
            String regex = "yes|no|ja|nein|on|off|true|false";
            return options.get(0).getValue().toLowerCase().matches(regex) && options.get(1).getValue().toLowerCase().matches(regex);
        }
        return false;
    }

    public static List<Item> createItems(Set<? extends DirectoryObject> ... directoryObjects) {
        return Arrays.asList(directoryObjects).stream().flatMap(ts -> ts.stream()).map(t -> new Item(t.getName(), ProfilePropertiesBuilder.getType(t.getClass()))).collect(Collectors.toList());
    }

    public static List<Item> createFilteredItemsFromDO(Set<? extends DirectoryObject> members, Class<?> ... clazz) {
        List<Class<?>> classList = Arrays.asList(clazz);
        return members.stream().filter(member -> classList.contains(member.getClass())).map(member -> new Item(member.getName(), ProfilePropertiesBuilder.getType(member.getClass()))).collect(Collectors.toList());
    }

    public static List<? extends DirectoryObject> createGroupedItems(Set<? extends DirectoryObject> directoryObjects) {
        HashMap map = new HashMap();
        for (DirectoryObject directoryObject : directoryObjects) {
            String schemaName = "Misc";
            if (directoryObject instanceof Profile) {
                Profile profile = (Profile)directoryObject;
                try {
                    Schema schema = profile.getSchema(profile.getRealm());
                    schemaName = schema.getLabel();
                }
                catch (Exception e) {
                    LOGGER.warn("Profile-list-grouping broken: cannot load schema for " + profile);
                }
            }
            if (!map.containsKey(schemaName)) {
                map.put(schemaName, new ArrayList());
            }
            ((List)map.get(schemaName)).add(directoryObject);
        }
        Map result = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        ArrayList<MenuGroupProfile> arrayList = new ArrayList<MenuGroupProfile>();
        for (Map.Entry entry : result.entrySet()) {
            arrayList.add(new MenuGroupProfile((String)entry.getKey()));
            ((List)entry.getValue()).sort(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase));
            arrayList.addAll((Collection)entry.getValue());
        }
        if (map.size() == 1) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    private static Item.Type getType(Class clazz) {
        Item.Type itemType;
        if (clazz.equals(Client.class)) {
            itemType = Item.Type.CLIENT;
        } else if (clazz.equals(Application.class)) {
            itemType = Item.Type.APPLICATION;
        } else if (clazz.equals(HardwareType.class)) {
            itemType = Item.Type.HARDWARE;
        } else if (clazz.equals(Location.class)) {
            itemType = Item.Type.LOCATION;
        } else if (clazz.equals(Device.class)) {
            itemType = Item.Type.DEVICE;
        } else if (clazz.equals(ApplicationGroup.class)) {
            itemType = Item.Type.APPLICATION_GROUP;
        } else if (clazz.equals(UserGroup.class)) {
            itemType = Item.Type.USER_GROUP;
        } else if (clazz.equals(ClientGroup.class)) {
            itemType = Item.Type.CLIENT_GROUP;
        } else if (clazz.equals(User.class)) {
            itemType = Item.Type.USER;
        } else if (clazz.equals(Printer.class)) {
            itemType = Item.Type.PRINTER;
        } else {
            throw new RuntimeException("ProfileObject class not mapped to item.Type: " + clazz);
        }
        return itemType;
    }

    public static class MenuGroupProfile
    extends Profile {
        public MenuGroupProfile(String name) {
            this.setName(name);
        }
    }
}

