/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import java.util.HashMap;
import java.util.Map;
import org.openthinclient.web.thinclient.component.ItemButtonComponent;

public class ReferencesComponent
extends CssLayout {
    private CssLayout referenceLine;
    private Button multiSelectPopupBtn;
    private Map<String, CssLayout> itemComponents = new HashMap<String, CssLayout>();

    public ReferencesComponent(String labelText) {
        this.addStyleName("referenceComponent");
        this.multiSelectPopupBtn = new Button();
        this.multiSelectPopupBtn.addStyleName("multiSelectPopupButton");
        this.multiSelectPopupBtn.setIcon((Resource)VaadinIcons.PLUS_CIRCLE_O);
        this.multiSelectPopupBtn.addStyleName("icon-only");
        this.multiSelectPopupBtn.addStyleName("borderless-colored");
        CssLayout hl = new CssLayout();
        hl.addStyleName("referenceComponentCaption");
        Label label = new Label(labelText);
        label.addStyleName("referenceLabel");
        hl.addComponents(new Component[]{label, this.multiSelectPopupBtn});
        this.addComponent((Component)hl);
        this.referenceLine = new CssLayout();
        this.referenceLine.addStyleName("referenceLine");
        this.addComponent((Component)this.referenceLine);
    }

    public ItemButtonComponent addItemComponent(String name, boolean isReadOnly) {
        ItemButtonComponent buttonComponent = new ItemButtonComponent(name, isReadOnly);
        this.itemComponents.put(name, buttonComponent);
        this.referenceLine.addComponent((Component)buttonComponent, this.referenceLine.getComponentCount());
        return buttonComponent;
    }

    public void removeItemComponent(String name) {
        if (this.itemComponents.containsKey(name)) {
            this.referenceLine.removeComponent((Component)this.itemComponents.get(name));
            this.itemComponents.remove(name);
        }
    }

    public Button getMultiSelectPopupBtn() {
        return this.multiSelectPopupBtn;
    }

    public void addReferenceSublineComponents(String name, Component ... components) {
        this.addStyleName("has-subline-content");
        CssLayout referenceContentLine = new CssLayout();
        referenceContentLine.setId(name);
        referenceContentLine.setStyleName("referenceLine");
        referenceContentLine.addStyleName("subline-content");
        this.addComponent((Component)referenceContentLine);
        referenceContentLine.addComponents(components);
    }

    public void removeReferenceSublineComponent(String name) {
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = this.getComponent(i);
            if (component.getId() == null || !component.getId().equals(name)) continue;
            this.removeComponent(component);
            break;
        }
    }
}

